/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import java.util.prefs.Preferences;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class FacileApp {
    private String appName = "FACILE-APP-";
    private String iniKeyLang = "LANG";
    private String iniKeymbAddr = "MBAddres";
    private String iniKeymbBaud = "MBBaudrate";
    private String iniKeymbParity = "MBParity";
    private String iniKeymbDelay = "MBDelay";
    public static String ini_gs_currentMeasrementType = "CURRENTMEASUREMENTTYPE";
    public static String ini_gs_connection = "CONNECTION";
    public static String ini_gs_fft = "FFT";
    public static String ini_gs_hpfFilter = "HPFFILTER";
    public static String ini_gs_reactivePowCalc = "REACTIVEPOWCALC";
    public static String ini_gs_rs485switch = "RS485SWITCH";
    public static String ini_gs_freqDetectioCH = "FREQDETECTIONCH";
    public static String ini_gs_voltageInputType = "VOLTAGEINPUTTYPE";
    public static String ini_gs_energySaving = "ENERGYSAVING";
    public static String ini_gs_efficiencyMeas = "EFFICIENCYMEAS";
    public static String ini_gs_measType = "MEASTYPE";
    public static String ini_gs_integratorCondition = "INTEGRATORCONDITION";
    public static String ini_gs_outputSwitchInitCond = "OUTPUTSWITCHCONDITION";
    public static String ini_gs_filteredMeas = "FILTEREDMEAS";
    public static String ini_gs_EnergyUnitFactor = "ENERGYUNITFACTOR";
    public static String ini_ps_TAratio = "TARATIO";
    public static String ini_ps_TAdelay = "TADELAY";
    public static String ini_ps_TVratio = "TVRATIO";
    public static String ini_ps_TVdelay = "TVDELAY";
    public static String ini_ps_minVolatgeRipple = "MINVOLTAGERIPPLE";
    public static String ini_ps_minCurrentRipple = "MINCURRENTRIPPLE";
    public static String ini_ps_minPowerRipple = "MINPOWERRIPPLE";
    public static String ini_ps_DCFilter = "DCFILTER";
    public static String ini_ps_ACFilter = "ACFILTER";
    public static String ini_ps_MAXDemand = "MINUTEMAXDEMAND";
    public static String ini_ps_POWERTHEXC = "POWERTRESHOLDEXC";
    public static String ini_ps_SECFORMEAN = "SECFORMEAN";
    public static String ini_ps_SECFORMAX = "SECFORMAX";
    public static String ini_ps_SECFORMINRMS = "SECFORMINRMS";
    public static String ini_a_FAILEEPROM = "FAILEEPROM";
    public static String ini_a_PHASEREVERSAL = "PHASEREVERSAL";
    public static String ini_a_I1OVERRANGE = "I1OVERRANGE";
    public static String ini_a_I1UNDERRANGE = "I1UNDERRANGE";
    public static String ini_a_I2OVERRANGE = "I2OVERRANGE";
    public static String ini_a_I2UNDERRANGE = "I2UNDERRANGE";
    public static String ini_a_I3OVERRANGE = "I3OVERRANGE";
    public static String ini_a_I3UNDERRANGE = "I3UNDERRANGE";
    public static String ini_a_V1OVERRANGE = "V1OVERRANGE";
    public static String ini_a_V1UNDERRANGE = "V1UNDERRANGE";
    public static String ini_a_V2OVERRANGE = "V2OVERRANGE";
    public static String ini_a_V2UNDERRANGE = "V2UNDERRANGE";
    public static String ini_a_V3OVERRANGE = "V3OVERRAGE";
    public static String ini_a_V3UNDERRANGE = "V3UNDERRANGE";
    public static String ini_a_AlarmRegisterStartAddress = "ALARAMREGISTERSTARTADDRESS";
    public static String ini_a_AlarmTripValue = "ALARMTRIPVALUE";
    public static String ini_a_AlarmTripValue2 = "ALARMTRIPVALUE2";
    public static String ini_a_AlarmHysteresis = "ALARAMHYSTERESIS";
    public static String ini_a_AlarmTresh_1 = "ALARMTRESH1";
    public static String ini_a_AlarmTresh_2 = "ALARMTRESH2";
    public static String ini_qs_NominalStarVoltage = "NOMINALSTARVOLTAGE";
    public static String ini_qs_SAGPercLvl = "SAGPERCLEVEL";
    public static String ini_qs_SWELLPercLvl = "SWELLPERCLEVEL";
    public static String ini_qs_Interruption = "INTERRUPTIONPERCLEVEL";
    public static String ini_qs_MinDuraionCutoff = "MINDURATIONCUTOFF";
    public FacileLangEnum lang;
    public FacileParam param = new FacileParam();
    public PagesEnum ultimaPagina;
    public boolean ultimaPaginaValida;
    public boolean isOffline;
    public String comName;
    public SerialPort coms;
    public int comBaud;
    public int comParity;
    public int comStopBits;
    public int modbusAddr;
    public int modbusTmo;
    public int qiDelay;
    public int fw_read = -1;
    public int[] bauds = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private int[] paritys;
    int totalDataL;

    public FacileApp() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.paritys = nArray;
        this.totalDataL = 0;
    }

    public boolean saveCfg(String filename) {
        try {
            Properties p = new Properties();
            p.setProperty(this.iniKeymbAddr, String.valueOf(Params.mbAddr));
            p.setProperty(this.iniKeymbBaud, String.valueOf(Params.mbBaud));
            p.setProperty(this.iniKeymbDelay, String.valueOf(Params.mbDelay));
            p.setProperty(this.iniKeymbParity, String.valueOf(Params.mbParity));
            this.comBaud = Params.mbBaud;
            this.modbusAddr = Params.mbAddr;
            p.setProperty(ini_gs_currentMeasrementType, String.valueOf(Params.gs_currentMeasrementType));
            p.setProperty(ini_gs_connection, String.valueOf(Params.gs_connection));
            p.setProperty(ini_gs_fft, String.valueOf(Params.gs_fft));
            p.setProperty(ini_gs_hpfFilter, String.valueOf(Params.gs_hpfFilter));
            p.setProperty(ini_gs_reactivePowCalc, String.valueOf(Params.gs_reactivePowCalc));
            p.setProperty(ini_gs_rs485switch, String.valueOf(Params.gs_rs485switch));
            p.setProperty(ini_gs_freqDetectioCH, String.valueOf(Params.gs_freqDetectioCH));
            p.setProperty(ini_gs_voltageInputType, String.valueOf(Params.gs_voltageInputType));
            p.setProperty(ini_gs_energySaving, String.valueOf(Params.gs_energySaving));
            p.setProperty(ini_gs_efficiencyMeas, String.valueOf(Params.gs_efficiencyMeas));
            p.setProperty(ini_gs_measType, String.valueOf(Params.gs_measType));
            p.setProperty(ini_gs_integratorCondition, String.valueOf(Params.gs_integratorCondition));
            p.setProperty(ini_gs_outputSwitchInitCond, String.valueOf(Params.gs_outputSwitchInitCond));
            p.setProperty(ini_gs_filteredMeas, String.valueOf(Params.gs_filteredMeas));
            p.setProperty(ini_gs_EnergyUnitFactor, String.valueOf(Params.gs_EnergyUnitFactor));
            p.setProperty(ini_ps_TAratio, String.valueOf(Params.ps_TAratio));
            p.setProperty(ini_ps_TAdelay, String.valueOf(Params.ps_TAdelay));
            p.setProperty(ini_ps_TVratio, String.valueOf(Params.ps_TVratio));
            p.setProperty(ini_ps_TVdelay, String.valueOf(Params.ps_TAdelay));
            p.setProperty(ini_ps_minVolatgeRipple, String.valueOf(Params.ps_minVolatgeRipple));
            p.setProperty(ini_ps_minCurrentRipple, String.valueOf(Params.ps_minCurrentRipple));
            p.setProperty(ini_ps_minPowerRipple, String.valueOf(Params.ps_minPowerRipple));
            p.setProperty(ini_ps_DCFilter, String.valueOf(Params.ps_DCFilter));
            p.setProperty(ini_ps_ACFilter, String.valueOf(Params.ps_ACFilter));
            p.setProperty(ini_ps_MAXDemand, String.valueOf(Params.ps_Min4MaxDemand));
            p.setProperty(ini_ps_POWERTHEXC, String.valueOf(Params.ps_PowThresholdExc));
            p.setProperty(ini_ps_SECFORMEAN, String.valueOf(Params.ps_Sec4MeanRMS));
            p.setProperty(ini_ps_SECFORMAX, String.valueOf(Params.ps_Sec4MaxRMS));
            p.setProperty(ini_ps_SECFORMINRMS, String.valueOf(Params.ps_Sec4MinRMS));
            p.setProperty(ini_a_FAILEEPROM, String.valueOf(Params.a_FAILEEPROM));
            p.setProperty(ini_a_PHASEREVERSAL, String.valueOf(Params.a_PHASEREVERSAL));
            p.setProperty(ini_a_I1OVERRANGE, String.valueOf(Params.a_I1OVERRANGE));
            p.setProperty(ini_a_I1UNDERRANGE, String.valueOf(Params.a_I1UNDERRANGE));
            p.setProperty(ini_a_I2OVERRANGE, String.valueOf(Params.a_I2OVERRANGE));
            p.setProperty(ini_a_I2UNDERRANGE, String.valueOf(Params.a_I2UNDERRANGE));
            p.setProperty(ini_a_I3OVERRANGE, String.valueOf(Params.a_I3OVERRANGE));
            p.setProperty(ini_a_I3UNDERRANGE, String.valueOf(Params.a_I3UNDERRANGE));
            p.setProperty(ini_a_V1OVERRANGE, String.valueOf(Params.a_V1OVERRANGE));
            p.setProperty(ini_a_V1UNDERRANGE, String.valueOf(Params.a_V1UNDERRANGE));
            p.setProperty(ini_a_V2OVERRANGE, String.valueOf(Params.a_V2OVERRANGE));
            p.setProperty(ini_a_V2UNDERRANGE, String.valueOf(Params.a_V2UNDERRANGE));
            p.setProperty(ini_a_V3OVERRANGE, String.valueOf(Params.a_V3OVERRANGE));
            p.setProperty(ini_a_V3UNDERRANGE, String.valueOf(Params.a_V3UNDERRANGE));
            p.setProperty(ini_a_AlarmRegisterStartAddress, String.valueOf(Params.a_AlarmRegisterStartAddress));
            p.setProperty(ini_a_AlarmTripValue, String.valueOf(Params.a_AlarmTripValue));
            p.setProperty(ini_a_AlarmTripValue2, String.valueOf(Params.a_AlarmTripValue2));
            p.setProperty(ini_a_AlarmHysteresis, String.valueOf(Params.a_AlarmHysteresis));
            p.setProperty(ini_a_AlarmTresh_1, String.valueOf(Params.a_AlarmTresh_1));
            p.setProperty(ini_a_AlarmTresh_2, String.valueOf(Params.a_AlarmTresh_2));
            p.setProperty(ini_qs_NominalStarVoltage, String.valueOf(Params.qs_NominalStarVoltage));
            p.setProperty(ini_qs_SAGPercLvl, String.valueOf(Params.qs_SAGpercLevel));
            p.setProperty(ini_qs_SWELLPercLvl, String.valueOf(Params.qs_SWELLpercLevel));
            p.setProperty(ini_qs_Interruption, String.valueOf(Params.qs_InterruptionLevel));
            p.setProperty(ini_qs_MinDuraionCutoff, String.valueOf(Params.qs_MinDurationCutOff));
            p.store(new FileOutputStream(filename), "");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage().toString());
            return false;
        }
        return true;
    }

    public boolean loadCfg(String filename) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(filename));
            Params.mbAddr = Integer.valueOf(p.getProperty(this.iniKeymbAddr));
            Params.mbBaud = Integer.valueOf(p.getProperty(this.iniKeymbBaud));
            Params.mbDelay = Integer.valueOf(p.getProperty(this.iniKeymbDelay));
            Params.mbParity = Integer.valueOf(p.getProperty(this.iniKeymbParity));
            Params.gs_currentMeasrementType = Integer.valueOf(p.getProperty(ini_gs_currentMeasrementType));
            Params.gs_connection = Integer.valueOf(p.getProperty(ini_gs_connection));
            Params.gs_fft = Integer.valueOf(p.getProperty(ini_gs_fft));
            Params.gs_hpfFilter = Integer.valueOf(p.getProperty(ini_gs_hpfFilter));
            Params.gs_reactivePowCalc = Integer.valueOf(p.getProperty(ini_gs_reactivePowCalc));
            Params.gs_rs485switch = Integer.valueOf(p.getProperty(ini_gs_rs485switch));
            Params.gs_freqDetectioCH = Integer.valueOf(p.getProperty(ini_gs_freqDetectioCH));
            Params.gs_voltageInputType = Integer.valueOf(p.getProperty(ini_gs_voltageInputType));
            Params.gs_energySaving = Integer.valueOf(p.getProperty(ini_gs_energySaving));
            Params.gs_efficiencyMeas = Integer.valueOf(p.getProperty(ini_gs_efficiencyMeas));
            Params.gs_measType = Integer.valueOf(p.getProperty(ini_gs_measType));
            Params.gs_integratorCondition = Integer.valueOf(p.getProperty(ini_gs_integratorCondition));
            Params.gs_filteredMeas = Integer.valueOf(p.getProperty(ini_gs_filteredMeas));
            Params.gs_EnergyUnitFactor = Integer.valueOf(p.getProperty(ini_gs_EnergyUnitFactor));
            Params.ps_TAratio = Float.valueOf(p.getProperty(ini_ps_TAratio)).floatValue();
            Params.ps_TAdelay = Float.valueOf(p.getProperty(ini_ps_TAdelay)).floatValue();
            Params.ps_TVratio = Float.valueOf(p.getProperty(ini_ps_TVratio)).floatValue();
            Params.ps_TVdelay = Float.valueOf(p.getProperty(ini_ps_TVdelay)).floatValue();
            Params.ps_minVolatgeRipple = Float.valueOf(p.getProperty(ini_ps_minVolatgeRipple)).floatValue();
            Params.ps_minCurrentRipple = Float.valueOf(p.getProperty(ini_ps_minCurrentRipple)).floatValue();
            Params.ps_minPowerRipple = Float.valueOf(p.getProperty(ini_ps_minPowerRipple)).floatValue();
            Params.ps_DCFilter = Integer.valueOf(p.getProperty(ini_ps_DCFilter));
            Params.ps_ACFilter = Integer.valueOf(p.getProperty(ini_ps_ACFilter));
            Params.ps_Min4MaxDemand = Integer.valueOf(p.getProperty(ini_ps_MAXDemand));
            Params.ps_PowThresholdExc = Integer.valueOf(p.getProperty(ini_ps_POWERTHEXC));
            Params.ps_Sec4MeanRMS = Integer.valueOf(p.getProperty(ini_ps_SECFORMEAN));
            Params.ps_Sec4MaxRMS = Integer.valueOf(p.getProperty(ini_ps_SECFORMAX));
            Params.ps_Sec4MinRMS = Integer.valueOf(p.getProperty(ini_ps_SECFORMINRMS));
            Params.a_FAILEEPROM = Integer.valueOf(p.getProperty(ini_a_FAILEEPROM));
            Params.a_PHASEREVERSAL = Integer.valueOf(p.getProperty(ini_a_PHASEREVERSAL));
            Params.a_I1OVERRANGE = Integer.valueOf(p.getProperty(ini_a_I1OVERRANGE));
            Params.a_I1UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_I1UNDERRANGE));
            Params.a_I2OVERRANGE = Integer.valueOf(p.getProperty(ini_a_I2OVERRANGE));
            Params.a_I2UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_I2UNDERRANGE));
            Params.a_I3OVERRANGE = Integer.valueOf(p.getProperty(ini_a_I3OVERRANGE));
            Params.a_I3UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_I3UNDERRANGE));
            Params.a_V1OVERRANGE = Integer.valueOf(p.getProperty(ini_a_V1OVERRANGE));
            Params.a_V1UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_V1UNDERRANGE));
            Params.a_V2OVERRANGE = Integer.valueOf(p.getProperty(ini_a_V2OVERRANGE));
            Params.a_V2UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_V2UNDERRANGE));
            Params.a_V3OVERRANGE = Integer.valueOf(p.getProperty(ini_a_V3OVERRANGE));
            Params.a_V3UNDERRANGE = Integer.valueOf(p.getProperty(ini_a_V3UNDERRANGE));
            Params.a_AlarmRegisterStartAddress = Integer.valueOf(p.getProperty(ini_a_AlarmRegisterStartAddress));
            Params.a_AlarmTripValue = Float.valueOf(p.getProperty(ini_a_AlarmTripValue)).floatValue();
            Params.a_AlarmTripValue2 = Float.valueOf(p.getProperty(ini_a_AlarmTripValue2)).floatValue();
            Params.a_AlarmHysteresis = Float.valueOf(p.getProperty(ini_a_AlarmHysteresis)).floatValue();
            Params.a_AlarmTresh_1 = Integer.valueOf(p.getProperty(ini_a_AlarmTresh_1));
            Params.a_AlarmTresh_2 = Integer.valueOf(p.getProperty(ini_a_AlarmTresh_2));
            Params.qs_NominalStarVoltage = Float.valueOf(p.getProperty(ini_qs_NominalStarVoltage)).floatValue();
            Params.qs_SAGpercLevel = Float.valueOf(p.getProperty(ini_qs_SAGPercLvl)).floatValue();
            Params.qs_SWELLpercLevel = Float.valueOf(p.getProperty(ini_qs_SWELLPercLvl)).floatValue();
            Params.qs_InterruptionLevel = Float.valueOf(p.getProperty(ini_qs_Interruption)).floatValue();
            Params.qs_MinDurationCutOff = Integer.valueOf(p.getProperty(ini_qs_MinDuraionCutoff));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void loadAppIni() {
        Preferences root = Preferences.userRoot();
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "023.ini");
        String content = "";
        this.lang = FacileLangEnum.FacileLangEN;
        try {
            FileReader reader = new FileReader(f2);
            char[] chars = new char[(int)f2.length()];
            reader.read(chars);
            content = new String(chars);
            reader.close();
            FacileParam.setLanguage(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveAppIni();
    }

    public void saveAppIni() {
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "023.ini");
        try {
            FileWriter writer = new FileWriter(f2);
            if (FacileParam.selectedLang == null) {
                FacileParam.selectedLang = "EN";
            }
            writer.write(FacileParam.selectedLang.toString());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String[] facileGetCommPorts() {
        return SerialPortList.getPortNames();
    }

    public boolean checkConnected(String com) {
        this.comName = com;
        this.isOffline = false;
        boolean connStatus = false;
        if (this.modbus_open()) {
            int[] rsp = this.modbus_read_holding_register(0, 2);
            if (rsp != null) {
                this.modbus_close();
                int _hw = rsp[1] / 256;
                int _fw = rsp[1] % 256;
                System.out.println("HW ver.:" + _hw);
                System.out.println("FW ver.:" + _fw);
                int _firmwareVer1 = _fw / 100;
                int _firmwareVer2 = _fw % 100 / 10;
                int _firmwareVer3 = _fw % 100 % 10;
                Params.machineID = rsp[0];
                Params.appFirmware = String.format("FW: %d.%d.%d", _firmwareVer1, _firmwareVer2, _firmwareVer3);
                this.fw_read = _fw;
                connStatus = rsp[0] == 23 || rsp[0] == 28 || rsp[0] == 32;
            } else {
                this.modbus_close();
                connStatus = false;
            }
        }
        this.modbus_close();
        return connStatus;
    }

    public String getStopBitsString() {
        if (this.comStopBits == 0) {
            return "1";
        }
        return "2";
    }

    private byte[] CRC_16(byte[] pbytModbus) {
        byte[] crc = new byte[2];
        int intLength = pbytModbus.length - 2;
        int lngCRC = 65535;
        int lngGenerator = 40961;
        int intI = 0;
        while (intI < intLength) {
            byte temp = pbytModbus[intI];
            lngCRC ^= temp & 0xFF;
            int intJ = 0;
            while (intJ < 8) {
                boolean blnBit = (lngCRC & 1) != 0;
                lngCRC >>>= 1;
                if (blnBit) {
                    lngCRC ^= 0xA001;
                }
                ++intJ;
            }
            ++intI;
        }
        crc[0] = (byte)(lngCRC & 0xFF);
        crc[1] = (byte)(lngCRC >> 8);
        return crc;
    }

    private void add_CRC_16(byte[] pbytModbus) {
        int intLength = pbytModbus.length - 2;
        byte[] crc = this.CRC_16(pbytModbus);
        pbytModbus[intLength++] = crc[0];
        pbytModbus[intLength] = crc[1];
    }

    private boolean Check_CRC(byte[] pbytModbus) {
        byte[] crc = this.CRC_16(pbytModbus);
        return crc[0] == pbytModbus[pbytModbus.length - 2] && crc[1] == pbytModbus[pbytModbus.length - 1];
    }

    private byte intToByte(int v) {
        byte b;
        if (v > 127) {
            b = (byte)v;
            b = (byte)(b + 256);
        } else {
            b = (byte)v;
        }
        return b;
    }

    private byte[] Read_Holding_Registers(int addr, int startRegister, int nRegister) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 3;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = 0;
        bytMessaggio[5] = (byte)nRegister;
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Single_Register(int addr, int Register, int Value) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 6;
        bytMessaggio[2] = (byte)(Register >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(Register & 0xFF);
        bytMessaggio[4] = (byte)(Value >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(Value & 0xFF);
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Multiple_Register(int addr, int startRegister, int[] values) {
        byte[] bytMessaggio = new byte[9 + values.length * 2];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 16;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = (byte)(values.length >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(values.length & 0xFF);
        bytMessaggio[6] = (byte)(values.length * 2);
        int i = 0;
        while (i < values.length) {
            bytMessaggio[7 + i * 2] = (byte)(values[i] >> 8 & 0xFF);
            bytMessaggio[8 + i * 2] = (byte)(values[i] & 0xFF);
            ++i;
        }
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] l_Write_Multiple_Register(int addr, int startRegister, long[] values) {
        byte[] bytMessaggio = new byte[9 + values.length * 2];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 16;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = (byte)(values.length >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(values.length & 0xFF);
        bytMessaggio[6] = (byte)(values.length * 2);
        int i = 0;
        while (i < values.length) {
            bytMessaggio[7 + i * 2] = (byte)(values[i] >> 8 & 0xFFL);
            bytMessaggio[8 + i * 2] = (byte)(values[i] & 0xFFL);
            ++i;
        }
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    public boolean modbus_open() {
        try {
            if (this.coms != null && this.coms.isOpened()) {
                this.coms.purgePort(1);
                this.coms.purgePort(2);
                this.coms.closePort();
            }
            this.coms = new SerialPort(this.comName);
            this.coms.openPort();
            this.coms.setParams(this.bauds[this.comBaud], 8, 1, this.paritys[this.comParity]);
            this.coms.setFlowControlMode(0);
            this.modbus_setTimeout();
        }
        catch (Exception e) {
            System.out.println("MODBUS-PORT error: " + e.getMessage());
            this.modbus_close();
            try {
                this.coms.closePort();
            }
            catch (SerialPortException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void modbus_close() {
        try {
            this.coms.purgePort(1);
            this.coms.purgePort(2);
            this.coms.closePort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] modbus_send_request(byte[] req, int tmo) {
        byte[] rsp = new byte[1024];
        byte[] rsp2 = new byte[1024];
        try {
            int i;
            this.coms.writeBytes(req);
            boolean nonarrivato = true;
            int tmocnt = 0;
            int len = 0;
            while (nonarrivato) {
                Thread.sleep(50L);
                rsp2 = this.coms.readBytes();
                int len2 = rsp2 != null ? rsp2.length : 0;
                if (len2 > 0) {
                    tmocnt = 0;
                    i = 0;
                    int j = len;
                    while (i < len2) {
                        if (j < 1024) {
                            rsp[j] = rsp2[i];
                        }
                        ++i;
                        ++j;
                    }
                    len = j;
                    continue;
                }
                if (len > 0) {
                    nonarrivato = false;
                    continue;
                }
                if ((tmocnt += 50) < tmo) continue;
                nonarrivato = false;
            }
            byte[] rspf = null;
            if (len > 0) {
                rspf = new byte[len];
                i = 0;
                while (i < len) {
                    rspf[i] = rsp[i];
                    ++i;
                }
            }
            return rspf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean modbus_check_valid_rsp(byte[] rsp, int addr) {
        int len = rsp.length;
        return len > 4 && rsp[0] == (byte)addr && this.Check_CRC(rsp);
    }

    public int[] modbus_read_holding_register(int startReg, int nRegs) {
        byte[] rsp = null;
        int[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new int[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public long[] l_modbus_read_holding_register(int startReg, int nRegs) {
        byte[] rsp = null;
        long[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new long[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public int modbus_read_holding_register_single_value(int startReg, int nRegs) {
        int i = 1;
        byte[] rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            int rhr_rsp = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
            return rhr_rsp;
        }
        return -1;
    }

    public long[] modbus_read_holding_register_with_harmonics(int startReg, int nRegs) {
        byte[] rsp = null;
        long[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new long[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = ((long)rsp[3 + 2 * i] & 0xFFL) * 256L + ((long)rsp[4 + 2 * i] & 0xFFL);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public byte[] modbus_write_single_register(int startReg, int value) {
        byte[] rsp = null;
        byte[] req = this.Write_Single_Register(this.modbusAddr, startReg, value);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public byte[] modbus_write_multiple_register(int startReg, int[] values) {
        byte[] rsp = null;
        byte[] req = this.Write_Multiple_Register(this.modbusAddr, startReg, values);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public byte[] l_modbus_write_multiple_register(int startReg, long[] values) {
        byte[] rsp = null;
        byte[] req = this.l_Write_Multiple_Register(this.modbusAddr, startReg, values);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public void sendDataToSerialPort(byte[] data) {
        int i = 0;
        while (i < data.length) {
            try {
                this.coms.writeByte(data[i]);
                this.totalDataL += data.length;
                System.out.println("Total data L = " + this.totalDataL);
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void sendStringSerialPort(String nachricht) {
        System.out.println("Sende: " + nachricht);
        try {
            this.coms.writeString(nachricht);
            System.out.println("Read: " + this.coms.readString());
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    public void readData() {
        try {
            while (true) {
                if (this.coms.getInputBufferBytesCount() > 0) {
                    System.out.print(this.coms.readString());
                    break;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void float_to_modbus_msw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos] = (bits & 0xFFFF0000) >>> 16;
        buf[pos + 1] = bits & 0xFFFF;
    }

    public void float_to_modbus_lsw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos + 1] = (bits & 0xFFFF0000) >>> 16;
        buf[pos] = bits & 0xFFFF;
    }

    public void long_to_modbus(long[] buf, int pos, long l) {
        buf[pos] = l & 0xFFFFL;
        buf[pos + 1] = l >> 16 & 0xFFFFL;
        buf[pos + 2] = l >> 32 & 0xFFFFL;
        buf[pos + 3] = l >> 48 & 0xFFFFL;
    }

    public long modbus_to_long(long[] buf, int pos) {
        long result = (buf[pos] & 0xFFFFL) << 48 | (buf[pos + 1] & 0xFFFFL) << 32 | (buf[pos + 2] & 0xFFFFL) << 16 | buf[pos + 3] & 0xFFFFL;
        return result;
    }

    public float modbus_msw_to_float(int[] buf, int pos) {
        int bits = buf[pos] << 16;
        return Float.intBitsToFloat(bits += buf[pos + 1]);
    }

    public float modbus_lsw_to_float(int[] buf, int pos) {
        int bits = buf[pos + 1] << 16;
        return Float.intBitsToFloat(bits += buf[pos]);
    }

    public long modbus_to_long(int[] buf, int pos) {
        long[] buf_x = new long[]{buf[pos], buf[pos + 1], buf[pos + 2], buf[pos + 3]};
        long result = (buf_x[3] & 0xFFFFL) << 48 | (buf_x[2] & 0xFFFFL) << 32 | (buf_x[1] & 0xFFFFL) << 16 | buf_x[0] & 0xFFFFL;
        return result;
    }

    public long modbus_to_long_32(int[] buf, int pos) {
        long[] buf_x = new long[]{buf[pos], buf[pos + 1]};
        long result = (buf_x[1] & 0xFFFFL) << 16 | buf_x[0] & 0xFFFFL;
        return result;
    }

    public int uint16_to_sint16(int u) {
        int s = u > Short.MAX_VALUE ? u - 65536 : u;
        return s;
    }

    public int sint16_to_uint16(int s) {
        int u = s < 0 ? s + 65536 : s;
        return u;
    }

    public int float_to_int(float f) {
        int n = Math.round(f);
        return n;
    }

    private void modbus_setTimeout() {
        this.modbusTmo = 1000;
    }

    public String getBaudString() {
        String s = String.format("%d", this.bauds[this.comBaud]);
        return s;
    }

    public String getParityString() {
        if (this.comParity == 0) {
            return "NO PARITY";
        }
        if (this.comParity == 1) {
            return "ODD PARITY";
        }
        return "EVEN PARITY";
    }

    public String getDelayString() {
        String s = String.format("%d", this.qiDelay);
        return s;
    }

    public static int[] reverse1DArray(int[] nums) {
        int[] numsReturn = new int[nums.length];
        int count = nums.length - 1;
        int[] nArray = nums;
        int n = nums.length;
        int n2 = 0;
        while (n2 < n) {
            int num;
            numsReturn[count] = num = nArray[n2];
            --count;
            ++n2;
        }
        return numsReturn;
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                System.out.println(String.format("%d", event.getEventValue()));
            } else if (event.isCTS()) {
                if (event.getEventValue() == 1) {
                    System.out.println("CTS - ON");
                } else {
                    System.out.println("CTS - OFF");
                }
            } else if (event.isDSR()) {
                if (event.getEventValue() == 1) {
                    System.out.println("DSR - ON");
                } else {
                    System.out.println("DSR - OFF");
                }
            }
        }
    }
}

