/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import java.util.prefs.Preferences;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortList;

public class FacileApp {
    private String appName = "FACILE-APP-";
    private String iniKeyLang = "LANG";
    private String iniKeyInSS = "IN-SS";
    private String iniKeyInSE = "IN-SE";
    private String iniKeyOutSS = "OUT-SS";
    private String iniKeyOutSE = "OUT-SE";
    private String iniKeyMBaddr = "MB-ADDR";
    private String iniKeyMBbaud = "MB-BAUD";
    private String iniKeyMBparity = "MB-PARITY";
    private String iniKeyMBdelay = "MB-DELAY";
    private String iniKeyFilt1 = "FILT-AVG";
    private String iniKeyFilt = "FILT-CFG";
    private String iniKeyCutoff = "CUT-OFF";
    public FacileLangEnum lang;
    public FacileParam param = new FacileParam();
    public FacilePagesEnum ultimaPagina;
    public boolean ultimaPaginaValida;
    public boolean isOffline;
    public String comName;
    public SerialPort coms;
    public int comBaud;
    public int comParity;
    public int modbusAddr;
    public int modbusTmo;
    public int qiDelay;
    public int fw_read = -1;
    private int[] bauds = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private int[] paritys;

    public FacileApp() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.paritys = nArray;
    }

    public boolean saveCfg(String filename) {
        try {
            Properties p = new Properties();
            p.setProperty(this.iniKeyInSS, this.param.getIniInSS());
            p.setProperty(this.iniKeyInSE, this.param.getIniInSE());
            p.setProperty(this.iniKeyOutSS, this.param.getIniOutSS());
            p.setProperty(this.iniKeyOutSE, this.param.getIniOutSE());
            p.setProperty(this.iniKeyMBaddr, this.param.getIniMBaddr());
            p.setProperty(this.iniKeyMBbaud, this.param.getIniMBbaud());
            p.setProperty(this.iniKeyMBparity, this.param.getIniMBparity());
            p.setProperty(this.iniKeyMBdelay, this.param.getIniMBdelay());
            p.setProperty(this.iniKeyFilt, this.param.getIniFilt());
            p.setProperty(this.iniKeyFilt1, this.param.getIniFilt1());
            p.setProperty(this.iniKeyCutoff, this.param.getIniCutoff());
            p.store(new FileOutputStream(filename), "");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean loadCfg(String filename) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(filename));
            this.param.setIniInSS(p.getProperty(this.iniKeyInSS));
            this.param.setIniInSE(p.getProperty(this.iniKeyInSE));
            this.param.setIniOutSS(p.getProperty(this.iniKeyOutSS));
            this.param.setIniOutSE(p.getProperty(this.iniKeyOutSE));
            this.param.setIniMBaddr(p.getProperty(this.iniKeyMBaddr));
            this.param.setIniMBbaud(p.getProperty(this.iniKeyMBbaud));
            this.param.setIniMBparity(p.getProperty(this.iniKeyMBparity));
            this.param.setIniMBdelay(p.getProperty(this.iniKeyMBdelay));
            this.param.setIniFilt(p.getProperty(this.iniKeyFilt));
            this.param.setIniFilt1(p.getProperty(this.iniKeyFilt1));
            this.param.setIniCutoff(p.getProperty(this.iniKeyCutoff));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void loadAppIni() {
        Preferences root = Preferences.userRoot();
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "004.ini");
        String content = "";
        this.lang = FacileLangEnum.FacileLangEN;
        try {
            FileReader reader = new FileReader(f2);
            char[] chars = new char[(int)f2.length()];
            reader.read(chars);
            content = new String(chars);
            reader.close();
            FacileParam.setLanguage(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveAppIni();
    }

    public void saveAppIni() {
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "004.ini");
        try {
            FileWriter writer = new FileWriter(f2);
            if (FacileParam.selectedLang == null) {
                FacileParam.selectedLang = "EN";
            }
            writer.write(FacileParam.selectedLang.toString());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String[] facileGetCommPorts() {
        return SerialPortList.getPortNames();
    }

    public boolean checkConnected(String com) {
        boolean st = false;
        this.comName = com;
        this.isOffline = false;
        if (this.modbus_open()) {
            int[] rsp = this.modbus_read_holding_register(0, 2);
            if (rsp != null && rsp[0] == 4 || rsp[0] == 16) {
                this.modbus_close();
                System.out.println("Machine ID: " + rsp[0]);
                System.out.println("FW version: " + rsp[1]);
                this.fw_read = rsp[1];
                FacileParam.FW_version = rsp[1];
                FacileParam.MachineID_version = rsp[0];
                if (rsp[0] == 4) {
                    FacileParam.MachineID_versionName = FacileParam.loadLanguage("machineID4");
                } else if (rsp[0] == 16) {
                    FacileParam.MachineID_versionName = FacileParam.loadLanguage("machineID16");
                }
                return true;
            }
            this.fw_read = -1;
            FacileParam.FW_version = -1;
            this.modbus_close();
            return false;
        }
        this.modbus_close();
        return false;
    }

    private byte[] CRC_16(byte[] pbytModbus) {
        byte[] crc = new byte[2];
        int intLength = pbytModbus.length - 2;
        int lngCRC = 65535;
        int lngGenerator = 40961;
        int intI = 0;
        while (intI < intLength) {
            byte temp = pbytModbus[intI];
            lngCRC ^= temp & 0xFF;
            int intJ = 0;
            while (intJ < 8) {
                boolean blnBit = (lngCRC & 1) != 0;
                lngCRC >>>= 1;
                if (blnBit) {
                    lngCRC ^= 0xA001;
                }
                ++intJ;
            }
            ++intI;
        }
        crc[0] = (byte)(lngCRC & 0xFF);
        crc[1] = (byte)(lngCRC >> 8);
        return crc;
    }

    private void add_CRC_16(byte[] pbytModbus) {
        int intLength = pbytModbus.length - 2;
        byte[] crc = this.CRC_16(pbytModbus);
        pbytModbus[intLength++] = crc[0];
        pbytModbus[intLength] = crc[1];
    }

    private boolean Check_CRC(byte[] pbytModbus) {
        byte[] crc = this.CRC_16(pbytModbus);
        return crc[0] == pbytModbus[pbytModbus.length - 2] && crc[1] == pbytModbus[pbytModbus.length - 1];
    }

    private byte intToByte(int v) {
        byte b;
        if (v > 127) {
            b = (byte)v;
            b = (byte)(b + 256);
        } else {
            b = (byte)v;
        }
        return b;
    }

    private byte[] Read_Holding_Registers(int addr, int startRegister, int nRegister) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 3;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = 0;
        bytMessaggio[5] = (byte)nRegister;
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Single_Register(int addr, int Register, int Value) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 6;
        bytMessaggio[2] = (byte)(Register >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(Register & 0xFF);
        bytMessaggio[4] = (byte)(Value >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(Value & 0xFF);
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Multiple_Register(int addr, int startRegister, int[] values) {
        byte[] bytMessaggio = new byte[9 + values.length * 2];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 16;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = (byte)(values.length >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(values.length & 0xFF);
        bytMessaggio[6] = (byte)(values.length * 2);
        int i = 0;
        while (i < values.length) {
            bytMessaggio[7 + i * 2] = (byte)(values[i] >> 8 & 0xFF);
            bytMessaggio[8 + i * 2] = (byte)(values[i] & 0xFF);
            ++i;
        }
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    public boolean modbus_open() {
        try {
            this.coms = new SerialPort(this.comName);
            this.coms.openPort();
            this.coms.setParams(this.bauds[this.comBaud], 8, 1, this.paritys[this.comParity]);
            this.coms.setFlowControlMode(0);
            this.modbus_setTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void modbus_close() {
        try {
            this.coms.closePort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] modbus_send_request(byte[] req, int tmo) {
        byte[] rsp = new byte[1024];
        byte[] rsp2 = new byte[1024];
        try {
            int i;
            this.coms.writeBytes(req);
            boolean nonarrivato = true;
            int tmocnt = 0;
            int len = 0;
            while (nonarrivato) {
                Thread.sleep(50L);
                rsp2 = this.coms.readBytes();
                int len2 = rsp2 != null ? rsp2.length : 0;
                if (len2 > 0) {
                    tmocnt = 0;
                    i = 0;
                    int j = len;
                    while (i < len2) {
                        if (j < 1024) {
                            rsp[j] = rsp2[i];
                        }
                        ++i;
                        ++j;
                    }
                    len = j;
                    continue;
                }
                if (len > 0) {
                    nonarrivato = false;
                    continue;
                }
                if ((tmocnt += 50) < tmo) continue;
                nonarrivato = false;
            }
            byte[] rspf = null;
            if (len > 0) {
                rspf = new byte[len];
                i = 0;
                while (i < len) {
                    rspf[i] = rsp[i];
                    ++i;
                }
            }
            return rspf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean modbus_check_valid_rsp(byte[] rsp, int addr) {
        int len = rsp.length;
        return len > 4 && rsp[0] == (byte)addr && this.Check_CRC(rsp);
    }

    public int[] modbus_read_holding_register(int startReg, int nRegs) {
        byte[] rsp = null;
        int[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new int[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public byte[] modbus_write_single_register(int startReg, int value) {
        byte[] rsp = null;
        byte[] req = this.Write_Single_Register(this.modbusAddr, startReg, value);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public byte[] modbus_write_multiple_register(int startReg, int[] values) {
        byte[] rsp = null;
        byte[] req = this.Write_Multiple_Register(this.modbusAddr, startReg, values);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public void float_to_modbus_msw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos] = (bits & 0xFFFF0000) >>> 16;
        buf[pos + 1] = bits & 0xFFFF;
    }

    public void float_to_modbus_lsw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos + 1] = (bits & 0xFFFF0000) >>> 16;
        buf[pos] = bits & 0xFFFF;
    }

    public float modbus_msw_to_float(int[] buf, int pos) {
        int bits = buf[pos] << 16;
        return Float.intBitsToFloat(bits += buf[pos + 1]);
    }

    public float modbus_lsw_to_float(int[] buf, int pos) {
        int bits = buf[pos + 1] << 16;
        return Float.intBitsToFloat(bits += buf[pos]);
    }

    public int uint16_to_sint16(int u) {
        int s = u > Short.MAX_VALUE ? u - 65536 : u;
        return s;
    }

    public int sint16_to_uint16(int s) {
        int u = s < 0 ? s + 65536 : s;
        return u;
    }

    public int float_to_int(float f) {
        int n = Math.round(f);
        return n;
    }

    private void modbus_setTimeout() {
        this.modbusTmo = 1000;
    }

    public String getBaudString() {
        String s = String.format("%d", this.bauds[this.comBaud]);
        return s;
    }

    public String getParityString() {
        if (this.comParity == 0) {
            return "NO PARITY";
        }
        if (this.comParity == 1) {
            return "ODD PARITY";
        }
        return "EVEN PARITY";
    }

    public String getDelayString() {
        String s = String.format("%d", this.qiDelay);
        return s;
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                System.out.println(String.format("%d", event.getEventValue()));
            } else if (event.isCTS()) {
                if (event.getEventValue() == 1) {
                    System.out.println("CTS - ON");
                } else {
                    System.out.println("CTS - OFF");
                }
            } else if (event.isDSR()) {
                if (event.getEventValue() == 1) {
                    System.out.println("DSR - ON");
                } else {
                    System.out.println("DSR - OFF");
                }
            }
        }
    }
}

