/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class FacileParam {
    static String[] um_str_ain = new String[]{"mV", "uA", "%", "\u00b0C", "\u00b0F", "Ohm", "Hz", "ms", ""};
    static String[] um_str_aout = new String[]{"mV", "uA"};
    public final ain_limit[] ain_limit_value = new ain_limit[]{new ain_limit(0.0f, 10000.0f), new ain_limit(0.0f, 20000.0f), new ain_limit(0.0f, 100.0f), new ain_limit(0.0f, 400.0f), new ain_limit(0.0f, 400.0f), new ain_limit(0.0f, 400.0f), new ain_limit(0.0f, 4000.0f), new ain_limit(0.0f, 4000.0f), new ain_limit(0.0f, 4000.0f), new ain_limit(-60.0f, 180.0f), new ain_limit(-60.0f, 180.0f), new ain_limit(-60.0f, 180.0f), new ain_limit(-200.0f, 600.0f), new ain_limit(-200.0f, 600.0f), new ain_limit(-200.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-100.0f, 600.0f), new ain_limit(-200.0f, 1200.0f), new ain_limit(-260.0f, 1360.0f), new ain_limit(-40.0f, 1760.0f), new ain_limit(-40.0f, 1760.0f), new ain_limit(-260.0f, 400.0f), new ain_limit(40.0f, 1820.0f), new ain_limit(-260.0f, 1000.0f), new ain_limit(-260.0f, 1280.0f)};
    public int ainType;
    public int ainTempUM;
    public int ainAvg;
    public int din_type;
    public int tot_inc;
    public int tot_edge;
    public int tot_roll;
    public float tot_filter;
    public int aout_type;
    public int aout_mode;
    public float inSS;
    public float inSE;
    public int outSS;
    public int outSE;
    public int dout_def;
    public boolean af_aout_man;
    public boolean af_aout_ur;
    public boolean af_aout_or;
    public boolean af_aout_hw;
    public boolean af_aout_log;
    public boolean af_aout_rtc;
    public boolean af_aout_eeprom;
    public boolean af_aout_alarm_en;
    public int af_aout_alarm_mode;
    public float af_aout_alarm_hyst;
    public float af_aout_alarm_th1;
    public float af_aout_alarm_th2;
    public boolean af_dout_ur;
    public boolean af_dout_or;
    public boolean af_dout_hw;
    public boolean af_dout_log;
    public boolean af_dout_rtc;
    public boolean af_dout_eeprom;
    public boolean af_dout_alarm_en;
    public boolean af_dout_din_en;
    public int af_dout_din_state;
    public int af_dout_state;
    public int mbAddr;
    public int mbBaud;
    public int mbParity;
    public int mbStopBits;
    public int log_en;
    public String log_filename;
    public int log_tc;
    public static int FW_version = -1;
    public static String MachineID_versionName = "";
    public static int MachineID_version = 0;
    public static String langFilePath = "";
    public static String selectedLang;

    public String getIniFloat(float f) {
        return Float.toString(f);
    }

    public float setIniFloat(String s) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public String getIniInteger(int s) {
        return Integer.toString(s);
    }

    public int setIniInteger(String s) {
        int f = 0;
        try {
            f = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public String getIniBoolean(boolean s) {
        return Boolean.toString(s);
    }

    public boolean setIniBoolean(String s) {
        boolean f = false;
        try {
            f = Boolean.parseBoolean(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public int forceIntParam(int v, int min, int max, int vdef) {
        int w = v;
        if (v < min || v > max) {
            w = vdef;
        }
        return w;
    }

    public float forceFloatParam(float v, float min, float max, float vdef) {
        float w = v;
        if (v < min || v > max) {
            w = vdef;
        }
        return w;
    }

    public String forceStringLen(String s, int len) {
        String stmp = s;
        if (s.length() > len) {
            stmp = stmp.substring(0, len);
        }
        return stmp;
    }

    public void validateParam() {
        this.ainType = this.forceIntParam(this.ainType, 0, 28, 0);
        this.ainTempUM = this.forceIntParam(this.ainTempUM, 0, 1, 0);
        this.ainAvg = this.forceIntParam(this.ainAvg, 1, 32, 1);
        this.din_type = this.forceIntParam(this.din_type, 0, 9, 0);
        this.tot_inc = this.forceIntParam(this.tot_inc, 0, 1, 0);
        this.tot_edge = this.forceIntParam(this.tot_edge, 0, 1, 0);
        this.tot_roll = this.forceIntParam(this.tot_roll, 0, 1, 0);
        this.aout_type = this.forceIntParam(this.aout_type, 0, 4, 0);
        this.aout_mode = this.forceIntParam(this.aout_mode, 0, 1, 0);
        this.dout_def = this.forceIntParam(this.dout_def, 0, 1, 0);
        this.tot_filter = this.forceFloatParam(this.tot_filter, 1.0f, 10000.0f, 10000.0f);
        this.af_aout_alarm_mode = this.forceIntParam(this.af_aout_alarm_mode, 0, 3, 0);
        this.af_dout_din_state = this.forceIntParam(this.af_dout_din_state, 0, 3, 0);
        this.af_dout_state = this.forceIntParam(this.af_dout_state, 0, 3, 0);
        this.mbAddr = this.forceIntParam(this.mbAddr, 1, 252, 1);
        this.mbBaud = this.forceIntParam(this.mbBaud, 0, 7, 3);
        this.mbParity = this.forceIntParam(this.mbParity, 0, 2, 0);
        this.mbStopBits = this.forceIntParam(this.af_dout_state, 0, 1, 1);
        if (this.mbParity > 0) {
            this.mbStopBits = 0;
        }
        this.log_en = this.forceIntParam(this.log_en, 0, 1, 0);
        this.log_tc = this.forceIntParam(this.log_tc, 1, 65535, 1);
        this.log_filename = this.forceStringLen(this.log_filename, 15);
        if (this.aout_mode == 0) {
            this.outSS = this.forceIntParam(this.outSS, 0, 10000, 0);
            this.outSE = this.forceIntParam(this.outSE, 0, 10000, 10000);
        } else {
            this.outSS = this.forceIntParam(this.outSS, 0, 20000, 0);
            this.outSE = this.forceIntParam(this.outSE, 0, 20000, 20000);
        }
        if (this.outSS > this.outSE) {
            this.outSS = this.outSE;
        }
        if (this.aout_type == 0) {
            this.inSS = this.forceFloatParam(this.inSS, this.ain_limit_value[this.ainType].low, this.ain_limit_value[this.ainType].high, this.ain_limit_value[this.ainType].low);
            this.inSE = this.forceFloatParam(this.inSE, this.ain_limit_value[this.ainType].low, this.ain_limit_value[this.ainType].high, this.ain_limit_value[this.ainType].high);
        } else if (this.aout_type == 1) {
            this.inSS = this.forceFloatParam(this.inSS, 0.001f, 10000.0f, 0.001f);
            this.inSE = this.forceFloatParam(this.inSE, 0.001f, 10000.0f, 10000.0f);
        } else if (this.aout_type == 2) {
            this.inSS = this.forceFloatParam(this.inSS, 100.0f, 1.0E9f, 100.0f);
            this.inSE = this.forceFloatParam(this.inSE, 100.0f, 1.0E9f, 1.0E9f);
        } else if (this.aout_type == 3) {
            this.inSS = this.forceFloatParam(this.inSS, 0.0f, 4.2949673E9f, 0.0f);
            this.inSE = this.forceFloatParam(this.inSE, 0.0f, 4.2949673E9f, 4.2949673E9f);
        } else {
            this.inSS = this.forceFloatParam(this.inSS, 0.0f, 100.0f, 0.0f);
            this.inSE = this.forceFloatParam(this.inSE, 0.0f, 100.0f, 100.0f);
        }
        if (this.inSS > this.inSE) {
            this.inSS = this.inSE;
        }
    }

    public void resetScale() {
        if (this.aout_type == 0) {
            this.inSS = this.ain_limit_value[this.ainType].low;
            this.inSE = this.ain_limit_value[this.ainType].high;
        } else if (this.aout_type == 1) {
            this.inSS = 0.001f;
            this.inSE = 10000.0f;
        } else if (this.aout_type == 2) {
            this.inSS = 100.0f;
            this.inSE = 1.0E9f;
        } else if (this.aout_type == 3) {
            this.inSS = 0.0f;
            this.inSE = 4.2949673E9f;
        } else {
            this.inSS = 0.0f;
            this.inSE = 100.0f;
        }
    }

    public void setFactoryDefault() {
        this.ainType = 0;
        this.ainTempUM = 0;
        this.ainAvg = 1;
        this.din_type = 0;
        this.tot_inc = 0;
        this.tot_edge = 0;
        this.tot_roll = 0;
        this.aout_type = 0;
        this.aout_mode = 0;
        this.dout_def = 0;
        this.tot_filter = 10000.0f;
        this.af_aout_man = false;
        this.af_aout_ur = false;
        this.af_aout_or = false;
        this.af_aout_hw = false;
        this.af_aout_log = false;
        this.af_aout_rtc = false;
        this.af_aout_eeprom = false;
        this.af_aout_alarm_en = false;
        this.af_dout_ur = false;
        this.af_dout_or = false;
        this.af_dout_hw = false;
        this.af_dout_log = false;
        this.af_dout_rtc = false;
        this.af_dout_eeprom = false;
        this.af_dout_alarm_en = false;
        this.af_dout_din_en = false;
        this.af_aout_alarm_mode = 0;
        this.af_dout_din_state = 0;
        this.af_dout_state = 0;
        this.mbAddr = 1;
        this.mbBaud = 3;
        this.mbParity = 0;
        this.mbStopBits = 1;
        this.log_en = 0;
        this.log_tc = 1;
        this.log_filename = "LOG.CSV";
        this.outSS = 0;
        this.outSE = 10000;
        this.inSS = 0.0f;
        this.inSE = 10000.0f;
    }

    public String[] getAll() {
        String[] s = new String[]{this.getIniInteger(this.ainType), this.getIniInteger(this.ainTempUM), this.getIniInteger(this.ainAvg), this.getIniInteger(this.din_type), this.getIniInteger(this.tot_inc), this.getIniInteger(this.tot_edge), this.getIniInteger(this.tot_roll), this.getIniFloat(this.tot_filter), this.getIniInteger(this.aout_type), this.getIniInteger(this.aout_mode), this.getIniFloat(this.inSS), this.getIniFloat(this.inSE), this.getIniInteger(this.outSS), this.getIniInteger(this.outSE), this.getIniInteger(this.dout_def), this.getIniBoolean(this.af_aout_ur), this.getIniBoolean(this.af_aout_or), this.getIniBoolean(this.af_aout_hw), this.getIniBoolean(this.af_aout_log), this.getIniBoolean(this.af_aout_rtc), this.getIniBoolean(this.af_aout_eeprom), this.getIniBoolean(this.af_aout_alarm_en), this.getIniInteger(this.af_aout_alarm_mode), this.getIniFloat(this.af_aout_alarm_hyst), this.getIniFloat(this.af_aout_alarm_th1), this.getIniFloat(this.af_aout_alarm_th2), this.getIniBoolean(this.af_dout_ur), this.getIniBoolean(this.af_dout_or), this.getIniBoolean(this.af_dout_hw), this.getIniBoolean(this.af_dout_log), this.getIniBoolean(this.af_dout_rtc), this.getIniBoolean(this.af_dout_eeprom), this.getIniBoolean(this.af_dout_alarm_en), this.getIniBoolean(this.af_dout_din_en), this.getIniInteger(this.af_dout_din_state), this.getIniInteger(this.af_dout_state), this.getIniInteger(this.mbAddr), this.getIniInteger(this.mbBaud), this.getIniInteger(this.mbParity), this.getIniInteger(this.mbStopBits), this.getIniInteger(this.log_en), this.log_filename, this.getIniInteger(this.log_tc), this.getIniBoolean(this.af_aout_man)};
        return s;
    }

    public void setAll(String[] s) {
        this.ainType = this.setIniInteger(s[0]);
        this.ainTempUM = this.setIniInteger(s[1]);
        this.ainAvg = this.setIniInteger(s[2]);
        this.din_type = this.setIniInteger(s[3]);
        this.tot_inc = this.setIniInteger(s[4]);
        this.tot_edge = this.setIniInteger(s[5]);
        this.tot_roll = this.setIniInteger(s[6]);
        this.tot_filter = this.setIniFloat(s[7]);
        this.aout_type = this.setIniInteger(s[8]);
        this.aout_mode = this.setIniInteger(s[9]);
        this.inSS = this.setIniFloat(s[10]);
        this.inSE = this.setIniFloat(s[11]);
        this.outSS = this.setIniInteger(s[12]);
        this.outSE = this.setIniInteger(s[13]);
        this.dout_def = this.setIniInteger(s[14]);
        this.af_aout_ur = this.setIniBoolean(s[15]);
        this.af_aout_or = this.setIniBoolean(s[16]);
        this.af_aout_hw = this.setIniBoolean(s[17]);
        this.af_aout_log = this.setIniBoolean(s[18]);
        this.af_aout_rtc = this.setIniBoolean(s[19]);
        this.af_aout_eeprom = this.setIniBoolean(s[20]);
        this.af_aout_alarm_en = this.setIniBoolean(s[21]);
        this.af_aout_alarm_mode = this.setIniInteger(s[22]);
        this.af_aout_alarm_hyst = this.setIniFloat(s[23]);
        this.af_aout_alarm_th1 = this.setIniFloat(s[24]);
        this.af_aout_alarm_th2 = this.setIniFloat(s[25]);
        this.af_dout_ur = this.setIniBoolean(s[26]);
        this.af_dout_or = this.setIniBoolean(s[27]);
        this.af_dout_hw = this.setIniBoolean(s[28]);
        this.af_dout_log = this.setIniBoolean(s[29]);
        this.af_dout_rtc = this.setIniBoolean(s[30]);
        this.af_dout_eeprom = this.setIniBoolean(s[31]);
        this.af_dout_alarm_en = this.setIniBoolean(s[32]);
        this.af_dout_din_en = this.setIniBoolean(s[33]);
        this.af_dout_din_state = this.setIniInteger(s[34]);
        this.af_dout_state = this.setIniInteger(s[35]);
        this.mbAddr = this.setIniInteger(s[36]);
        this.mbBaud = this.setIniInteger(s[37]);
        this.mbParity = this.setIniInteger(s[38]);
        this.mbStopBits = this.setIniInteger(s[39]);
        this.log_en = this.setIniInteger(s[40]);
        this.log_filename = s[41];
        this.log_tc = this.setIniInteger(s[42]);
        this.af_aout_man = this.setIniBoolean(s[43]);
    }

    public int getTotFilterSamples(float f) {
        f = 20000.0f / f;
        int nc = (int)((double)f / 2.0);
        return nc;
    }

    public float setTotFilterSamples(int n) {
        float f = (float)n * 2.0f;
        f = 20000.0f / f;
        return f;
    }

    public int getBooleanToInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public boolean setBooleanToInt(int v) {
        return v != 0;
    }

    public static boolean isAinTemp(int ainType) {
        return ainType >= ain_type_code_enum.AIN_TYPE_CODE_NI100_2W.ordinal();
    }

    public static String getAinUM(int ainType, int aoutType, int tempUM) {
        if (aoutType == 0) {
            if (FacileParam.isAinTemp(ainType)) {
                if (tempUM == 0) {
                    return um_str_ain[um_str_ain_um_enum.UM_TC.ordinal()];
                }
                return um_str_ain[um_str_ain_um_enum.UM_TF.ordinal()];
            }
            if (ainType == 0) {
                return um_str_ain[um_str_ain_um_enum.UM_mV.ordinal()];
            }
            if (ainType == 1) {
                return um_str_ain[um_str_ain_um_enum.UM_uA.ordinal()];
            }
            if (ainType == 2) {
                return um_str_ain[um_str_ain_um_enum.UM_PERC.ordinal()];
            }
            return um_str_ain[um_str_ain_um_enum.UM_OHM.ordinal()];
        }
        if (aoutType == 1) {
            return um_str_ain[um_str_ain_um_enum.UM_Hz.ordinal()];
        }
        if (aoutType == 2) {
            return um_str_ain[um_str_ain_um_enum.UM_s.ordinal()];
        }
        if (aoutType == 3) {
            return um_str_ain[um_str_ain_um_enum.UM_TOT.ordinal()];
        }
        return um_str_ain[um_str_ain_um_enum.UM_PERC.ordinal()];
    }

    public static String getOutUM(int aoutMode) {
        if (aoutMode == 0) {
            return um_str_aout[0];
        }
        return um_str_aout[1];
    }

    float getAinLimitLow(int ainType) {
        return this.ain_limit_value[ainType].low;
    }

    float getAinLimitHigh(int ainType) {
        return this.ain_limit_value[ainType].high;
    }

    public static String getApplicationStartUpPath() {
        String retPath = "";
        try {
            retPath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retPath;
    }

    public static String getApplicationLogo() {
        return String.valueOf(FacileParam.getApplicationStartUpPath()) + "/applogo.png";
    }

    public static String loadLanguage(String propertyName) {
        Properties p = new Properties();
        try {
            if (selectedLang == null || selectedLang.equals("")) {
                selectedLang = "EN";
            }
            String tempPath = String.valueOf(FacileParam.getApplicationStartUpPath()) + "/" + selectedLang + ".lng";
            p.load(new FileInputStream(tempPath));
            return p.getProperty(propertyName).toString();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            System.out.println(e);
            return p.getProperty(propertyName).toString();
        }
    }

    public static ArrayList<HashMap<String, String>> getLanguageFileList() {
        ArrayList<HashMap<String, String>> languageList = new ArrayList<HashMap<String, String>>();
        File home = new File(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/");
        if (home.listFiles(new FileExtensionFilter()).length > 0) {
            File[] fileArray = home.listFiles(new FileExtensionFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                HashMap<String, String> lang = new HashMap<String, String>();
                lang.put("language", file.getName().substring(0, file.getName().length() - 4));
                lang.put("languagePath", file.getPath());
                languageList.add(lang);
                ++n2;
            }
        }
        return languageList;
    }

    public static void setLanguage(String strLang) {
        selectedLang = strLang;
    }

    static class FileExtensionFilter
    implements FilenameFilter {
        FileExtensionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".lng") || name.endsWith(".LNG");
        }
    }

    public class ain_limit {
        float low;
        float high;

        public ain_limit(float l, float h) {
            this.low = l;
            this.high = h;
        }
    }

    static enum ain_type_code_enum {
        AIN_TYPE_CODE_VOLTAGE,
        AIN_TYPE_CODE_CURRENT,
        AIN_TYPE_CODE_POTENT,
        AIN_TYPE_CODE_R400_2W,
        AIN_TYPE_CODE_R400_3W,
        AIN_TYPE_CODE_R400_4W,
        AIN_TYPE_CODE_R4000_2W,
        AIN_TYPE_CODE_R4000_3W,
        AIN_TYPE_CODE_R4000_4W,
        AIN_TYPE_CODE_NI100_2W,
        AIN_TYPE_CODE_NI100_3W,
        AIN_TYPE_CODE_NI100_4W,
        AIN_TYPE_CODE_PT100_2W,
        AIN_TYPE_CODE_PT100_3W,
        AIN_TYPE_CODE_PT100_4W,
        AIN_TYPE_CODE_PT500_2W,
        AIN_TYPE_CODE_PT500_3W,
        AIN_TYPE_CODE_PT500_4W,
        AIN_TYPE_CODE_PT1000_2W,
        AIN_TYPE_CODE_PT1000_3W,
        AIN_TYPE_CODE_PT1000_4W,
        AIN_TYPE_CODE_TC_J,
        AIN_TYPE_CODE_TC_K,
        AIN_TYPE_CODE_TC_R,
        AIN_TYPE_CODE_TC_S,
        AIN_TYPE_CODE_TC_T,
        AIN_TYPE_CODE_TC_B,
        AIN_TYPE_CODE_TC_E,
        AIN_TYPE_CODE_TC_N;

    }

    static enum um_str_ain_um_enum {
        UM_mV,
        UM_uA,
        UM_PERC,
        UM_TC,
        UM_TF,
        UM_OHM,
        UM_Hz,
        UM_s,
        UM_TOT;

    }
}

