/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FacileWinEN
implements FacileEventsInterface,
ActionListener {
    private FacileParam fpp;
    private JFrame frmFacileWinEN;
    private JButton btnIndietro;
    private JPanel pnlTab;
    private JButton btnAvanti;
    private JMenuBar menuBar;
    private JMenu mnAzioni;
    private JMenuItem mntmSelezioneLingua;
    private JMenuItem mntmEsci;
    private FacileIntroEN tabIntroIT;
    private FacileConnectionTypeEN tabConnectionTypeIT;
    private FacileConnectionModeEN tabConnectionModeIT;
    private FacileConnectionRicManEN tabConnectionRicManIT;
    private FacileMenuLoadTestEN tabMenuLoadTestIT;
    private FacileMenuSaveSendEN tabMenuSaveSendIT;
    private FacileCfg1EN tabCfg1IT;
    private FacileCfg2EN tabCfg2IT;
    private FacileCfg3EN tabCfg3IT;
    private FacileCfg4EN tabCfg4IT;
    private FacileTestEN tabTestIT;
    private JButton btnHome;
    private JButton btnEsci;
    private FacilePagesEnum currPage;
    private FacileApp fapp;
    private FacileWinThreadEN fth;
    private Timer tmr;
    private boolean mbOpened = false;

    public FacileWinEN(FacileApp fa, FacileWinThreadEN wth) {
        this.fapp = fa;
        this.fth = wth;
        this.initialize();
    }

    private void initialize() {
        this.frmFacileWinEN = new JFrame();
        ImageIcon ImageIcon2 = new ImageIcon(String.valueOf(FacileParam.getApplicationStartUpPath()) + "/appicon.png");
        Image Image2 = ImageIcon2.getImage();
        this.frmFacileWinEN.setDefaultCloseOperation(0);
        this.frmFacileWinEN.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FacileWinEN.this.startEsci();
            }
        });
        this.frmFacileWinEN.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }
        });
        this.frmFacileWinEN.setResizable(false);
        this.frmFacileWinEN.setTitle("005 v1.0.4");
        this.frmFacileWinEN.setSize(new Dimension(800, 600));
        this.frmFacileWinEN.setBounds(100, 100, 800, 600);
        this.menuBar = new JMenuBar();
        this.menuBar.setBackground(SystemColor.menu);
        this.menuBar.setFont(new Font("Segoe UI", 1, 12));
        this.frmFacileWinEN.setJMenuBar(this.menuBar);
        this.mnAzioni = new JMenu("Actions");
        this.mnAzioni = new JMenu(FacileParam.loadLanguage("mnAzioni"));
        this.mnAzioni.setBackground(SystemColor.menu);
        this.mnAzioni.setFont(new Font("Segoe UI", 1, 12));
        this.menuBar.add(this.mnAzioni);
        this.mntmSelezioneLingua = new JMenuItem(FacileParam.loadLanguage("mntmSelezioneLingua"));
        this.mntmSelezioneLingua.addActionListener(this);
        this.mntmSelezioneLingua.setBackground(SystemColor.menu);
        this.mntmSelezioneLingua.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(this.mntmSelezioneLingua);
        JMenuItem mntmVerificaAggiornamento = new JMenuItem(FacileParam.loadLanguage("mntmVerificaAggiornamento"));
        mntmVerificaAggiornamento.setVisible(false);
        mntmVerificaAggiornamento.setBackground(SystemColor.menu);
        mntmVerificaAggiornamento.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(mntmVerificaAggiornamento);
        this.mntmEsci = new JMenuItem(FacileParam.loadLanguage("mntmEsci"));
        this.mntmEsci.addActionListener(this);
        this.mntmEsci.setBackground(SystemColor.menu);
        this.mntmEsci.setFont(new Font("Segoe UI", 1, 12));
        this.mnAzioni.add(this.mntmEsci);
        this.frmFacileWinEN.getContentPane().setLayout(null);
        this.btnIndietro = new JButton(FacileParam.loadLanguage("btnIndietro"));
        this.btnIndietro.addActionListener(this);
        this.btnIndietro.setCursor(Cursor.getPredefinedCursor(12));
        this.btnIndietro.setBounds(258, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnIndietro);
        this.pnlTab = new JPanel();
        this.pnlTab.setName("PANEL1");
        this.pnlTab.setBackground(new Color(72, 209, 204));
        this.pnlTab.setBounds(10, 11, 774, 465);
        this.frmFacileWinEN.getContentPane().add(this.pnlTab);
        this.pnlTab.setLayout(null);
        this.btnAvanti = new JButton(FacileParam.loadLanguage("btnAvanti"));
        this.btnAvanti.addActionListener(this);
        this.btnAvanti.setCursor(Cursor.getPredefinedCursor(12));
        this.btnAvanti.setBounds(440, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnAvanti);
        this.btnHome = new JButton(FacileParam.loadLanguage("btnHome"));
        this.btnHome.addActionListener(this);
        this.btnHome.setCursor(Cursor.getPredefinedCursor(12));
        this.btnHome.setBounds(10, 487, 163, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnHome);
        this.btnEsci = new JButton(FacileParam.loadLanguage("btnEsci"));
        this.btnEsci.addActionListener(this);
        this.btnEsci.setCursor(Cursor.getPredefinedCursor(12));
        this.btnEsci.setBounds(679, 487, 105, 52);
        this.frmFacileWinEN.getContentPane().add(this.btnEsci);
        this.tabIntroIT = new FacileIntroEN();
        this.tabIntroIT.setFacileEventHandler(this);
        this.tabConnectionTypeIT = new FacileConnectionTypeEN();
        this.tabConnectionTypeIT.setFacileEventHandler(this);
        this.tabConnectionModeIT = new FacileConnectionModeEN();
        this.tabConnectionModeIT.setFacileEventHandler(this);
        this.tabConnectionRicManIT = new FacileConnectionRicManEN();
        this.tabConnectionRicManIT.setFacileEventHandler(this);
        this.tabMenuLoadTestIT = new FacileMenuLoadTestEN();
        this.tabMenuLoadTestIT.setFacileEventHandler(this);
        this.tabMenuSaveSendIT = new FacileMenuSaveSendEN();
        this.tabMenuSaveSendIT.setFacileEventHandler(this);
        this.tabCfg1IT = new FacileCfg1EN();
        this.tabCfg1IT.setFacileEventHandler(this);
        this.tabCfg2IT = new FacileCfg2EN();
        this.tabCfg2IT.setFacileEventHandler(this);
        this.tabCfg3IT = new FacileCfg3EN();
        this.tabCfg3IT.setFacileEventHandler(this);
        this.tabCfg4IT = new FacileCfg4EN();
        this.tabCfg4IT.setFacileEventHandler(this);
        this.tabTestIT = new FacileTestEN(this.frmFacileWinEN);
        this.tabTestIT.setFacileEventHandler(this);
        this.fapp.isOffline = true;
        this.fapp.ultimaPaginaValida = false;
        this.tmr = new Timer(100, this);
        this.setFacilePageIntro();
    }

    public JButton getBtnNewButton() {
        return this.btnIndietro;
    }

    public JPanel getPanel() {
        return this.pnlTab;
    }

    public JButton getBtnAvanti() {
        return this.btnAvanti;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getMnFile() {
        return this.mnAzioni;
    }

    public JMenuItem getMntmSelezioneLingua() {
        return this.mntmSelezioneLingua;
    }

    public JMenuItem getMntmEsci() {
        return this.mntmEsci;
    }

    @Override
    public void executeEvent(FacileEventsEnum ev) {
        if (ev == FacileEventsEnum.FacileEvCfg) {
            this.setFacilePageConnectionType();
        } else if (ev == FacileEventsEnum.FacileEvFWupd) {
            this.setFacilePageFWupdate();
        } else if (ev == FacileEventsEnum.FacileEvUSB) {
            this.setFacilePageConnectionMode();
        } else if (ev == FacileEventsEnum.FacileEvOffline) {
            this.fapp.isOffline = true;
            this.setFacilePageMenuLoadTest();
        } else if (ev != FacileEventsEnum.FacileEvRicercaAutomatica) {
            if (ev == FacileEventsEnum.FacileEvRicercaManuale) {
                this.setFacilePageConnectionRicMan();
            } else if (ev == FacileEventsEnum.FacileEvRicercaManualeAggiorna) {
                this.aggiornaFacilePageConnectionRicMan();
            } else if (ev == FacileEventsEnum.FacileEvCfgDefault) {
                this.fapp.param.setFactoryDefault();
                this.setFacilePageCfg1();
            } else if (ev == FacileEventsEnum.FacileEvGoCfgStart) {
                this.setFacilePageMenuLoadTest();
            } else if (ev != FacileEventsEnum.FacileEvFwStart) {
                if (ev == FacileEventsEnum.FacileEvRicercaManualeStart) {
                    this.startRicercaManuale();
                } else if (ev == FacileEventsEnum.FacileEvLoadFile) {
                    this.startLoadFile();
                } else if (ev == FacileEventsEnum.FacileEvSaveFile) {
                    this.startSaveFile();
                } else if (ev == FacileEventsEnum.FacileEvSendDev) {
                    if (this.sendCfgToDev()) {
                        this.setFacilePageTest();
                    }
                } else if (ev == FacileEventsEnum.FacileEvLoadDev) {
                    if (this.readCfgFromDev()) {
                        // empty if block
                    }
                    this.setFacilePageCfg1();
                } else if (ev == FacileEventsEnum.FacileEvTest) {
                    this.setFacilePageTest();
                } else if (ev == FacileEventsEnum.FacileEvReadRTC) {
                    this.readRTC();
                } else if (ev == FacileEventsEnum.FacileEvWriteRTC) {
                    this.writeRTC(false);
                } else if (ev == FacileEventsEnum.FacileEvSyncWriteRTC) {
                    this.writeRTC(true);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnHome) {
            this.endTestTimer();
            this.setFacilePageIntro();
        } else if (e.getSource() == this.btnAvanti) {
            if (this.currPage == FacilePagesEnum.FacilePageIntro) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg1) {
                this.tabCfg1IT.savePage(this.fapp.param);
                this.setFacilePageCfg2();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg2) {
                this.tabCfg2IT.savePage(this.fapp.param);
                this.setFacilePageCfg3();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg3) {
                this.tabCfg3IT.savePage(this.fapp.param);
                this.setFacilePageCfg4();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg4) {
                this.tabCfg4IT.savePage(this.fapp.param);
                this.setFacilePageMenuSaveSend();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionMode) {
                this.fapp.isOffline = false;
                this.setFacilePageConnectionRicMan();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionRicMan) {
                this.fapp.isOffline = false;
                this.setFacilePageMenuLoadTest();
            }
        } else if (e.getSource() == this.btnIndietro) {
            if (this.currPage == FacilePagesEnum.FacilePageFWupdCfg) {
                this.setFacilePageIntro();
            } else if (this.currPage == FacilePagesEnum.FacilePageFWupdate) {
                this.setFacilePageFWupdCfg();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionType) {
                this.setFacilePageIntro();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionMode) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageConnectionRicMan) {
                this.setFacilePageConnectionMode();
            } else if (this.currPage == FacilePagesEnum.FacilePageMenuLoadTest) {
                this.setFacilePageConnectionType();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg1) {
                this.tabCfg1IT.savePage(this.fapp.param);
                this.setFacilePageMenuLoadTest();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg2) {
                this.tabCfg2IT.savePage(this.fapp.param);
                this.setFacilePageCfg1();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg3) {
                this.tabCfg3IT.savePage(this.fapp.param);
                this.setFacilePageCfg2();
            } else if (this.currPage == FacilePagesEnum.FacilePageCfg4) {
                this.tabCfg4IT.savePage(this.fapp.param);
                this.setFacilePageCfg3();
            } else if (this.currPage == FacilePagesEnum.FacilePageMenuSaveSend) {
                this.setFacilePageCfg4();
            } else if (this.currPage == FacilePagesEnum.FacilePageTest) {
                this.endTestTimer();
                this.setFacilePageMenuLoadTest();
            }
        } else if (e.getSource() == this.btnEsci) {
            this.startEsci();
        } else if (e.getSource() == this.mntmEsci) {
            this.startEsci();
        } else if (e.getSource() == this.mntmSelezioneLingua) {
            FacileLangEN fd = new FacileLangEN();
            fd.showCentered(this.frmFacileWinEN.getBounds());
            fd.setVisible(true);
            if (fd.isOk()) {
                this.endTestTimer();
                this.fapp.lang = fd.getLang();
                this.fapp.saveAppIni();
                this.frmFacileWinEN.setVisible(false);
                this.frmFacileWinEN.dispose();
                this.fth.ended = false;
                this.fth.changeLang = true;
            }
            fd.dispose();
        } else {
            this.tmr.stop();
            if (this.currPage == FacilePagesEnum.FacilePageTest) {
                this.readTestFromDev();
                this.tmr.start();
            }
        }
    }

    protected JButton getBtnHome() {
        return this.btnHome;
    }

    protected JButton getBtnEsci() {
        return this.btnEsci;
    }

    protected void setFacilePage(FacilePagesEnum p, Component c) {
        this.fapp.ultimaPagina = this.currPage;
        this.fapp.ultimaPaginaValida = true;
        this.currPage = p;
        this.pnlTab.removeAll();
        this.pnlTab.add(c);
        this.pnlTab.repaint();
        this.pnlTab.setVisible(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pnlTab.setVisible(true);
    }

    protected void setFacilePageIntro() {
        this.setFacilePage(FacilePagesEnum.FacilePageIntro, this.tabIntroIT);
        this.btnHome.setEnabled(false);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(false);
    }

    protected void setFacilePageFWupdCfg() {
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionType() {
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionType, this.tabConnectionTypeIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageFWupdate() {
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionMode() {
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionMode, this.tabConnectionModeIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageConnectionRicMan() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.tabConnectionRicManIT.setSerialPorts(coms);
        this.setFacilePage(FacilePagesEnum.FacilePageConnectionRicMan, this.tabConnectionRicManIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void aggiornaFacilePageConnectionRicMan() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.tabConnectionRicManIT.setSerialPorts(coms);
    }

    protected void setFacilePageMenuLoadTest() {
        this.tabMenuLoadTestIT.setOffline(this.fapp.isOffline);
        this.setFacilePage(FacilePagesEnum.FacilePageMenuLoadTest, this.tabMenuLoadTestIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageCfg1() {
        this.tabCfg1IT.initPage(this.fapp.param);
        this.setFacilePage(FacilePagesEnum.FacilePageCfg1, this.tabCfg1IT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageCfg2() {
        this.tabCfg2IT.initPage(this.fapp.param);
        this.setFacilePage(FacilePagesEnum.FacilePageCfg2, this.tabCfg2IT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageCfg3() {
        this.tabCfg3IT.initPage(this.fapp.param);
        this.setFacilePage(FacilePagesEnum.FacilePageCfg3, this.tabCfg3IT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageCfg4() {
        this.tabCfg4IT.initPage(this.fapp.param);
        this.tabCfg4IT.setOffline(this.fapp.isOffline);
        if (!this.fapp.isOffline) {
            this.readRTC();
        }
        this.setFacilePage(FacilePagesEnum.FacilePageCfg4, this.tabCfg4IT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageMenuSaveSend() {
        this.tabCfg1IT.savePage(this.fapp.param);
        this.tabCfg2IT.savePage(this.fapp.param);
        this.tabCfg3IT.savePage(this.fapp.param);
        this.tabCfg4IT.savePage(this.fapp.param);
        this.tabMenuSaveSendIT.setOffline(this.fapp.isOffline);
        this.setFacilePage(FacilePagesEnum.FacilePageMenuSaveSend, this.tabMenuSaveSendIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacilePageTest() {
        this.tabTestIT.setNessunValore();
        this.tabTestIT.setPbar(10);
        this.tabTestIT.setCommString(String.format("%s Baud %s 8bit %s Stopbit", this.fapp.getBaudString(), this.fapp.getParityString(), this.fapp.getStopBitsString()));
        this.setFacilePage(FacilePagesEnum.FacilePageTest, this.tabTestIT);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
        this.tmr.setInitialDelay(5);
        this.tmr.setDelay(10);
        this.tmr.setRepeats(false);
        this.tmr.start();
    }

    public void facileShow() {
        this.frmFacileWinEN.setVisible(true);
    }

    public boolean isFacileShowed() {
        return this.frmFacileWinEN.isVisible();
    }

    private void startEsci() {
        Object[] options = new Object[]{FacileParam.loadLanguage("boxYesUscita"), FacileParam.loadLanguage("boxNoUscita")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextUscita"), FacileParam.loadLanguage("boxTitleUscita"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
            this.fth.changeLang = false;
        }
    }

    private void startFwUpdateUSBdisk() {
        Object[] options2;
        Object[] options = new Object[]{"SI", "ANNULLA"};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "INSERT THE USB KEY TO BE USED FOR UPDATING THE FIRMWARE", "FACILE", 0, 3, null, options, options[1]);
        if (n == 0 && (n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "ALL DATA WILL BE LOST THE USB KEY, SURE TO CONTINUE?", "FACILE", 0, 2, null, options2 = new Object[]{"CONFERMA", "ANNULLA"}, options2[1])) == 0) {
            JFileChooser f = new JFileChooser();
            f.setFileSelectionMode(0);
            f.setFileFilter(new FileNameExtensionFilter("FACILE FIRMWARE UPDATE", ".FFW"));
            f.setMultiSelectionEnabled(false);
            if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
                File fn = f.getSelectedFile();
                Object[] options3 = new Object[]{"CONTINUA"};
                if (fn.isFile() && fn.exists()) {
                    Object[] disks = new Object[]{"DISCO A", "DISCO B"};
                    String diskSel = (String)JOptionPane.showInputDialog(this.frmFacileWinEN, "SELEZIONARE IL DISCO RIMOVIBILE DA UTILIZZARE PER L'AGGIORNAMENTO FIRMWARE", "FACILE", 3, null, disks, disks[0]);
                    n = JOptionPane.showOptionDialog(this.frmFacileWinEN, String.format("SICURI DI SELEZIONARE IL DISCO %s", diskSel), "FACILE", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "CHIAVETTA USB CREATA CON SUCCESSO", "FACILE", 0, 1, null, options3, options3[0]);
                    }
                } else {
                    n = JOptionPane.showOptionDialog(this.frmFacileWinEN, "ERRORE : IL FILE NON ESISTE", "FACILE", 0, 0, null, options3, options3[0]);
                }
            }
        }
    }

    private void startRicercaManuale() {
        Object[] options = new Object[]{FacileParam.loadLanguage("boxTextConnectedBtn")};
        String com = this.tabConnectionRicManIT.getSelectedComPort();
        this.fapp.modbusAddr = 1;
        this.fapp.comBaud = 3;
        this.fapp.comParity = 0;
        this.fapp.comStopBits = 1;
        if (this.fapp.checkConnected(com)) {
            if (this.fapp.fw_read == -1) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxWrongDevice"), FacileParam.loadLanguage("boxWrongDeviceTitle"), 0, 1, null, options, options[0]);
            } else if (this.fapp.fw_read >= 0 && this.fapp.fw_read < 10) {
                this.frmFacileWinEN.setTitle(String.format("005 v1.0.4 FW: %d.%d.%d", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10));
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextConnected"), FacileParam.loadLanguage("boxTitleConnected"), 0, 1, null, options, options[0]);
                this.setFacilePageMenuLoadTest();
            } else {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, String.format("DEVICE CONNECTED WITH FIRMWARE VERSION %d.%d.%d INCOMPATIBLE WITH THIS SOFTWARE", this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10), FacileParam.loadLanguage("boxAppTitle"), 0, 1, null, options, options[0]);
                this.setFacilePageMenuLoadTest();
            }
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextError"), FacileParam.loadLanguage("boxTitleError"), 0, 0, null, options, options[0]);
        }
    }

    private void startLoadFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
            File fn = f.getSelectedFile();
            Object[] options3 = new Object[]{FacileParam.loadLanguage("boxLoadFileBtnText")};
            if (fn.isFile() && fn.exists()) {
                if (this.fapp.loadCfg(fn.getAbsolutePath())) {
                    this.setFacilePageCfg1();
                } else {
                    int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxLoadFileError1"), FacileParam.loadLanguage("boxLoadFileTitle"), 0, 0, null, options3, options3[0]);
                }
                return;
            }
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxLoadFileError3"), FacileParam.loadLanguage("boxLoadFileTitle"), 0, 0, null, options3, options3[0]);
        }
    }

    private void startSaveFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showSaveDialog(this.frmFacileWinEN) == 0) {
            String extension;
            File fn = f.getSelectedFile();
            String path = fn.getAbsolutePath();
            if (!path.endsWith(extension = ".TXT")) {
                fn = new File(String.valueOf(path) + extension);
            }
            Object[] options3 = new Object[]{FacileParam.loadLanguage("boxSaveFileContinue")};
            boolean toSave = false;
            if (fn.exists()) {
                Object[] options2 = new Object[]{FacileParam.loadLanguage("boxSaveFileOK"), FacileParam.loadLanguage("boxSaveFileCancel")};
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxSaveFileQuestion"), FacileParam.loadLanguage("boxSaveFileTitle"), 0, 2, null, options2, options2[1]);
                if (n == 0) {
                    toSave = true;
                }
            } else {
                toSave = true;
            }
            if (toSave && !this.fapp.saveCfg(fn.getAbsolutePath())) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxSaveFileError"), FacileParam.loadLanguage("boxSaveFileTitle"), 0, 0, null, options3, options3[0]);
            }
        }
    }

    private boolean sendCfgToDev() {
        boolean ok = false;
        byte[] reply = null;
        if (this.fapp.modbus_open()) {
            int[] values = new int[12];
            values[0] = this.fapp.param.ainType;
            values[1] = this.fapp.param.din_type;
            values[2] = this.fapp.param.ainAvg * 256 + this.fapp.param.ainTempUM;
            values[3] = this.fapp.param.tot_inc * 1 + this.fapp.param.tot_edge * 2 + this.fapp.param.tot_roll * 4;
            values[4] = this.fapp.param.getTotFilterSamples(this.fapp.param.tot_filter);
            values[5] = this.fapp.param.aout_type == 4 ? this.fapp.param.aout_mode * 1 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_ur) * 8 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_or) * 16 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_hw) * 32 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_log) * 64 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_rtc) * 128 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_eeprom) * 256 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_alarm_en) * 512 + this.fapp.param.af_aout_alarm_mode * 1024 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_man) * 4096 + 8192 : this.fapp.param.aout_mode * 1 + this.fapp.param.aout_type * 2 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_ur) * 8 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_or) * 16 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_hw) * 32 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_log) * 64 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_rtc) * 128 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_eeprom) * 256 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_alarm_en) * 512 + this.fapp.param.af_aout_alarm_mode * 1024 + this.fapp.param.getBooleanToInt(this.fapp.param.af_aout_man) * 4096;
            if (this.fapp.param.aout_mode == 2) {
                this.fapp.param.inSS = (float)((double)this.fapp.param.inSS * 1000.0);
                this.fapp.param.inSE = (float)((double)this.fapp.param.inSE * 1000.0);
            }
            this.fapp.float_to_modbus_lsw(values, 6, this.fapp.param.inSS);
            this.fapp.float_to_modbus_lsw(values, 8, this.fapp.param.inSE);
            values[10] = this.fapp.param.outSS;
            values[11] = this.fapp.param.outSE;
            reply = this.fapp.modbus_write_multiple_register(100, values);
            if (reply != null) {
                values = new int[19];
                values[0] = this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_ur) * 2 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_or) * 4 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_hw) * 8 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_log) * 16 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_rtc) * 32 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_eeprom) * 64 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_alarm_en) * 128 + this.fapp.param.getBooleanToInt(this.fapp.param.af_dout_din_en) * 256 + this.fapp.param.af_dout_din_state * 512 + this.fapp.param.af_dout_state * 1024;
                this.fapp.float_to_modbus_lsw(values, 1, this.fapp.param.af_aout_alarm_th1);
                this.fapp.float_to_modbus_lsw(values, 3, this.fapp.param.af_aout_alarm_th2);
                this.fapp.float_to_modbus_lsw(values, 5, this.fapp.param.af_aout_alarm_hyst);
                values[7] = this.fapp.param.mbAddr * 256 + this.fapp.param.mbParity * 1 + this.fapp.param.mbStopBits * 4;
                values[8] = this.fapp.param.mbBaud;
                values[9] = this.fapp.param.log_en;
                values[10] = this.fapp.param.log_tc;
                this.fapp.modbus_string_write(values, 11, this.fapp.param.log_filename, 8);
                reply = this.fapp.modbus_write_multiple_register(112, values);
                if (reply != null && (reply = this.fapp.modbus_write_single_register(2000, 2)) != null) {
                    ok = true;
                }
            }
        }
        Object[] options3 = new Object[]{FacileParam.loadLanguage("boxTextConfChangeBtn")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextConfChange"), FacileParam.loadLanguage("boxTitleConfChange"), 0, 1, null, options3, options3[0]);
            reply = this.fapp.modbus_write_single_register(2000, 1);
            this.fapp.modbus_close();
            if (reply != null) {
                ok = true;
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.fapp.modbusAddr = this.fapp.param.mbAddr;
                this.fapp.comBaud = this.fapp.param.mbBaud;
                this.fapp.comParity = this.fapp.param.mbParity;
                this.fapp.comStopBits = this.fapp.param.mbStopBits;
            } else {
                ok = false;
                this.fapp.modbus_close();
                n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextErrorComm"), FacileParam.loadLanguage("boxTitleErrorCommTitle"), 0, 0, null, options3, options3[0]);
            }
            return ok;
        }
        this.fapp.modbus_close();
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextConfChangeErrorSend"), FacileParam.loadLanguage("boxTitleConfChangeErrorTitleSend"), 0, 0, null, options3, options3[0]);
        return ok;
    }

    private boolean readCfgFromDev() {
        boolean ok = false;
        if (this.fapp.modbus_open()) {
            int[] values = null;
            values = this.fapp.modbus_read_holding_register(100, 12);
            if (values != null) {
                this.fapp.param.ainType = values[0];
                this.fapp.param.din_type = values[1];
                this.fapp.param.ainAvg = (values[2] & 0xFF00) / 256;
                this.fapp.param.ainTempUM = values[2] & 0xFF;
                this.fapp.param.tot_inc = (values[3] & 1) / 1;
                this.fapp.param.tot_edge = (values[3] & 2) / 2;
                this.fapp.param.tot_roll = (values[3] & 4) / 4;
                this.fapp.param.tot_filter = this.fapp.param.setTotFilterSamples(values[4]);
                this.fapp.param.aout_mode = (values[5] & 1) / 1;
                this.fapp.param.aout_type = (values[5] & 6) / 2;
                if ((values[5] & 0x2000) != 0) {
                    this.fapp.param.aout_type = 4;
                }
                this.fapp.param.af_aout_ur = this.fapp.param.setBooleanToInt((values[5] & 8) / 8);
                this.fapp.param.af_aout_or = this.fapp.param.setBooleanToInt((values[5] & 0x10) / 16);
                this.fapp.param.af_aout_hw = this.fapp.param.setBooleanToInt((values[5] & 0x20) / 32);
                this.fapp.param.af_aout_log = this.fapp.param.setBooleanToInt((values[5] & 0x40) / 64);
                this.fapp.param.af_aout_rtc = this.fapp.param.setBooleanToInt((values[5] & 0x80) / 128);
                this.fapp.param.af_aout_eeprom = this.fapp.param.setBooleanToInt((values[5] & 0x100) / 256);
                this.fapp.param.af_aout_alarm_en = this.fapp.param.setBooleanToInt((values[5] & 0x200) / 512);
                this.fapp.param.af_aout_alarm_mode = (values[5] & 0xC00) / 1024;
                this.fapp.param.af_aout_man = this.fapp.param.setBooleanToInt((values[5] & 0x1000) / 4096);
                this.fapp.param.inSS = this.fapp.modbus_lsw_to_float(values, 6);
                this.fapp.param.inSE = this.fapp.modbus_lsw_to_float(values, 8);
                if (this.fapp.param.aout_mode == 2) {
                    this.fapp.param.inSS = (float)((double)this.fapp.param.inSS / 1000.0);
                    this.fapp.param.inSE = (float)((double)this.fapp.param.inSE / 1000.0);
                }
                this.fapp.param.outSS = values[10];
                this.fapp.param.outSE = values[11];
                values = this.fapp.modbus_read_holding_register(112, 19);
                if (values != null) {
                    this.fapp.param.af_dout_ur = this.fapp.param.setBooleanToInt((values[0] & 2) / 2);
                    this.fapp.param.af_dout_or = this.fapp.param.setBooleanToInt((values[0] & 4) / 4);
                    this.fapp.param.af_dout_hw = this.fapp.param.setBooleanToInt((values[0] & 8) / 8);
                    this.fapp.param.af_dout_log = this.fapp.param.setBooleanToInt((values[0] & 0x10) / 16);
                    this.fapp.param.af_dout_rtc = this.fapp.param.setBooleanToInt((values[0] & 0x20) / 32);
                    this.fapp.param.af_dout_eeprom = this.fapp.param.setBooleanToInt((values[0] & 0x40) / 64);
                    this.fapp.param.af_dout_alarm_en = this.fapp.param.setBooleanToInt((values[0] & 0x80) / 128);
                    this.fapp.param.af_dout_din_en = this.fapp.param.setBooleanToInt((values[0] & 0x100) / 256);
                    this.fapp.param.af_dout_din_state = (values[0] & 0x200) / 512;
                    this.fapp.param.af_dout_state = (values[0] & 0x400) / 1024;
                    this.fapp.param.af_aout_alarm_th1 = this.fapp.modbus_lsw_to_float(values, 1);
                    this.fapp.param.af_aout_alarm_th2 = this.fapp.modbus_lsw_to_float(values, 3);
                    this.fapp.param.af_aout_alarm_hyst = this.fapp.modbus_lsw_to_float(values, 5);
                    this.fapp.param.mbAddr = (values[7] & 0xFF00) / 256;
                    this.fapp.param.mbParity = (values[7] & 3) / 1;
                    this.fapp.param.mbStopBits = (values[7] & 4) / 4;
                    this.fapp.param.mbBaud = values[8];
                    this.fapp.param.log_en = values[9];
                    this.fapp.param.log_tc = values[10];
                    this.fapp.param.log_filename = this.fapp.modbus_string_read(values, 11, 8);
                    ok = true;
                }
            }
        }
        this.fapp.modbus_close();
        Object[] options3 = new Object[]{FacileParam.loadLanguage("boxAppContinue")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextReadConfOK"), FacileParam.loadLanguage("boxTitleReadConfOK"), 0, 1, null, options3, options3[0]);
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxTextReadConfERR"), FacileParam.loadLanguage("boxTitleReadConfERR"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }

    private boolean readTestFromDev() {
        byte[] reply = null;
        boolean ok = false;
        Object[] options3 = new Object[]{"CONTINUE"};
        ok = false;
        if (this.mbOpened) {
            ok = true;
        } else if (this.fapp.modbus_open()) {
            this.mbOpened = true;
            ok = true;
        }
        if (ok) {
            int[] values = null;
            values = this.fapp.modbus_read_holding_register(0, 25);
            if (values != null) {
                try {
                    int status = values[4];
                    long tot = (long)values[6] * 65536L + (long)values[7];
                    int aout = values[8];
                    float ain = this.fapp.modbus_lsw_to_float(values, 9);
                    float period = this.fapp.modbus_lsw_to_float(values, 11);
                    period = (float)((double)period / 1000.0);
                    float dc = this.fapp.modbus_lsw_to_float(values, 23);
                    float freq = this.fapp.modbus_lsw_to_float(values, 13);
                    float cj = this.fapp.modbus_lsw_to_float(values, 15);
                    float tcmv = this.fapp.modbus_lsw_to_float(values, 17);
                    int dout = values[19];
                    int um_ain = (values[20] & 0xF00) / 256;
                    int um_aout = (values[20] & 0x8000) / 32768;
                    this.tabTestIT.setCommString(String.format("%s Baud %s 8bit %s Stopbit - UnitID = %d - FW = %d.%d.%d", this.fapp.getBaudString(), this.fapp.getParityString(), this.fapp.getStopBitsString(), (long)values[2] * 65536L + (long)values[3], this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10));
                    this.tabTestIT.setNoCommunication(false);
                    this.tabTestIT.setValori(status, tot, aout, ain, period, freq, tcmv, um_ain, um_aout, dc);
                    this.tabTestIT.avanzamento();
                    if (this.tabTestIT.getWritePending() == 1) {
                        int m = this.tabTestIT.getWriteSource();
                        int v = this.tabTestIT.getWriteValue();
                        this.tabTestIT.resetWritePending();
                        values = new int[2];
                        this.fapp.float_to_modbus_lsw(values, 0, v);
                        if (m == 0) {
                            reply = this.fapp.modbus_write_single_register(19, v);
                        } else if (m == 1) {
                            reply = this.fapp.modbus_write_single_register(8, v);
                        } else if (m == 2) {
                            int[] v2 = new int[]{v / 65536, v % 65536};
                            reply = this.fapp.modbus_write_multiple_register(6, v2);
                        }
                        ok = reply != null;
                    } else {
                        ok = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!ok) {
            this.tabTestIT.setNoCommunication(true);
        }
        return ok;
    }

    private void endTestTimer() {
        this.tmr.stop();
        if (this.mbOpened) {
            this.fapp.modbus_close();
            this.mbOpened = false;
        }
    }

    private boolean readRTC() {
        boolean ok = false;
        if (this.fapp.modbus_open()) {
            int[] values = null;
            values = this.fapp.modbus_read_holding_register(1000, 6);
            if (values != null) {
                this.tabCfg4IT.setRTC(values);
                ok = true;
            }
        }
        this.fapp.modbus_close();
        Object[] options3 = new Object[]{FacileParam.loadLanguage("boxAppContinue")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxDTReadOK"), FacileParam.loadLanguage("boxAppTitle"), 0, 1, null, options3, options3[0]);
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxDTReadNOK"), FacileParam.loadLanguage("boxAppTitle"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }

    private boolean writeRTC(boolean b) {
        boolean ok = false;
        if (this.fapp.modbus_open()) {
            byte[] reply = null;
            if (b) {
                Calendar d = Calendar.getInstance();
                int[] regs = new int[]{d.get(1), d.get(2) + 1, d.get(5), d.get(11), d.get(12), d.get(13)};
                reply = this.fapp.modbus_write_multiple_register(1000, regs);
                if (reply != null) {
                    this.tabCfg4IT.setRTC(regs);
                }
            } else {
                reply = this.fapp.modbus_write_multiple_register(1000, this.tabCfg4IT.getRTC());
            }
            if (reply != null) {
                ok = true;
            }
        }
        this.fapp.modbus_close();
        Object[] options3 = new Object[]{FacileParam.loadLanguage("boxAppContinue")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxDTWriteOK"), FacileParam.loadLanguage("boxAppTitle"), 0, 1, null, options3, options3[0]);
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("boxDTWriteNOK"), FacileParam.loadLanguage("boxAppTitle"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }
}

