/*
 * Decompiled with CFR 0.152.
 */
package QA12DI4DO;

import QA12DI4DO.CommPortSelection;
import QA12DI4DO.ConnectionMode;
import QA12DI4DO.ConnectionTypeWnd;
import QA12DI4DO.EventsEnum;
import QA12DI4DO.EventsInterface;
import QA12DI4DO.FacileApp;
import QA12DI4DO.FacileLangEN;
import QA12DI4DO.FacileParam;
import QA12DI4DO.IntroWnd;
import QA12DI4DO.MainThread;
import QA12DI4DO.Measurement;
import QA12DI4DO.MenuSaveSend;
import QA12DI4DO.MenuTest;
import QA12DI4DO.PagesEnum;
import QA12DI4DO.Params;
import QA12DI4DO.Settings;
import QA12DI4DO.SettingsComm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class WinEn
implements EventsInterface,
ActionListener {
    private FacileApp fapp;
    private MainThread fth;
    private JFrame frmFacileWinEN;
    private JButton btnAvanti;
    private JButton btnHome;
    private JButton btnEsci;
    private JButton btnIndietro;
    private JPanel pnlTab;
    private IntroWnd pnlIntroWnd;
    private ConnectionTypeWnd pnlConnType;
    private ConnectionMode pnlConnMode;
    private CommPortSelection pnlCommPortSelection;
    private Settings pnlSettings;
    private MenuTest pnlLoadTest;
    private MenuSaveSend pnlMenuSaveSend;
    private Measurement pnlMeasurement;
    private SettingsComm pnlSettingsComm;
    private JMenuItem mntmChangeLanguage;
    private PagesEnum currPage;
    private Timer tmr;
    private boolean mbOpened = false;
    private JMenuItem mntmQuit;

    public WinEn(FacileApp fa, MainThread wth) {
        this.fapp = fa;
        this.fth = wth;
        this.initialize();
    }

    private void initialize() {
        this.frmFacileWinEN = new JFrame();
        this.frmFacileWinEN.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WinEn.this.exitFromApp();
            }
        });
        this.frmFacileWinEN.setResizable(false);
        this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 0.0");
        this.frmFacileWinEN.setSize(new Dimension(800, 600));
        this.frmFacileWinEN.setBounds(100, 100, 800, 600);
        this.frmFacileWinEN.setDefaultCloseOperation(3);
        this.frmFacileWinEN.getContentPane().setLayout(null);
        this.pnlTab = new JPanel();
        this.pnlTab.setName("PANEL1");
        this.pnlTab.setBackground(new Color(72, 209, 204));
        this.pnlTab.setBounds(10, 11, 774, 485);
        this.frmFacileWinEN.getContentPane().add(this.pnlTab);
        this.pnlTab.setLayout(null);
        this.btnAvanti = new JButton(FacileParam.loadLanguage("btnAvanti"));
        this.btnAvanti.addActionListener(this);
        this.btnAvanti.setCursor(Cursor.getPredefinedCursor(12));
        this.btnAvanti.setBounds(440, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnAvanti);
        this.btnHome = new JButton(FacileParam.loadLanguage("btnHome"));
        this.btnHome.addActionListener(this);
        this.btnHome.setCursor(Cursor.getPredefinedCursor(12));
        this.btnHome.setBounds(10, 500, 163, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnHome);
        this.btnIndietro = new JButton(FacileParam.loadLanguage("btnIndietro"));
        this.btnIndietro.addActionListener(this);
        this.btnIndietro.setCursor(Cursor.getPredefinedCursor(12));
        this.btnIndietro.setBounds(258, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnIndietro);
        this.btnEsci = new JButton(FacileParam.loadLanguage("btnEsci"));
        this.btnEsci.addActionListener(this);
        this.btnEsci.setCursor(Cursor.getPredefinedCursor(12));
        this.btnEsci.setBounds(679, 500, 105, 45);
        this.frmFacileWinEN.getContentPane().add(this.btnEsci);
        this.pnlIntroWnd = new IntroWnd();
        this.pnlIntroWnd.setLocation(0, 0);
        this.pnlIntroWnd.setSize(774, 485);
        this.pnlIntroWnd.setEventHandler(this);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBackground(SystemColor.menu);
        menuBar.setFont(new Font("Segoe UI", 1, 12));
        this.frmFacileWinEN.setJMenuBar(menuBar);
        JMenu mnActions = new JMenu(FacileParam.loadLanguage("mnActions"));
        menuBar.add(mnActions);
        this.mntmChangeLanguage = new JMenuItem(FacileParam.loadLanguage("mntmChangeLanguage"));
        this.mntmChangeLanguage.addActionListener(this);
        mnActions.add(this.mntmChangeLanguage);
        this.mntmQuit = new JMenuItem(FacileParam.loadLanguage("mntmQuit"));
        this.mntmQuit.addActionListener(this);
        mnActions.add(this.mntmQuit);
        this.pnlConnType = new ConnectionTypeWnd();
        this.pnlConnType.setEventHandler(this);
        this.pnlConnMode = new ConnectionMode();
        this.pnlConnMode.setEventHandler(this);
        this.pnlCommPortSelection = new CommPortSelection();
        this.pnlCommPortSelection.setEventHandler(this);
        this.pnlSettings = new Settings();
        this.pnlSettings.setEventHandler(this);
        this.pnlLoadTest = new MenuTest();
        this.pnlLoadTest.setEventHandler(this);
        this.pnlMenuSaveSend = new MenuSaveSend();
        this.pnlMenuSaveSend.setEventHandler(this);
        this.pnlMeasurement = new Measurement(this.fapp, this.frmFacileWinEN);
        this.pnlMeasurement.setEventHandler(this);
        this.pnlSettingsComm = new SettingsComm();
        this.pnlSettingsComm.setEventHandler(this);
        this.fapp.ultimaPaginaValida = false;
        this.tmr = new Timer(100, this);
        this.setPageIntro();
    }

    public void facileShow() {
        this.frmFacileWinEN.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnHome) {
            this.fapp.isOffline = true;
            this.fapp.modbus_close();
            this.endTestTimer();
            this.setPageIntro();
        } else if (e.getSource() == this.btnAvanti) {
            if (this.currPage == PagesEnum.Intro) {
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.ConnectionMode) {
                this.setCommPortSelection();
            } else if (this.currPage == PagesEnum.CommPortSelection) {
                this.setLoadTest();
            } else if (this.currPage == PagesEnum.SettingsComm) {
                this.setSettingsPage();
            } else if (this.currPage == PagesEnum.Settings) {
                this.setMenuSaveSendTest();
            }
        } else if (e.getSource() == this.btnEsci) {
            this.exitFromApp();
        } else if (e.getSource() == this.btnIndietro) {
            if (this.currPage == PagesEnum.ConnectionTypeWnd) {
                this.setPageIntro();
            } else if (this.currPage == PagesEnum.ConnectionMode) {
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.LoadTest) {
                if (this.fapp.isOffline) {
                    this.setConnectionType();
                } else {
                    this.setCommPortSelection();
                }
            } else if (this.currPage == PagesEnum.Settings) {
                this.setSettingsCommunication();
            } else if (this.currPage == PagesEnum.CommPortSelection) {
                this.setPageConnectionMode();
            } else if (this.currPage == PagesEnum.MeasurementWnd) {
                this.fapp.isOffline = true;
                this.setConnectionType();
            } else if (this.currPage == PagesEnum.MenuSaveSend) {
                this.setSettingsPage();
            } else if (this.currPage == PagesEnum.SettingsComm) {
                this.setLoadTest();
            }
        } else if (e.getSource() == this.mntmChangeLanguage) {
            FacileLangEN fd = new FacileLangEN();
            fd.showCentered(this.frmFacileWinEN.getBounds());
            fd.setVisible(true);
            if (fd.isOk()) {
                this.endTestTimer();
                this.fapp.lang = fd.getLang();
                this.fapp.saveAppIni();
                this.frmFacileWinEN.setVisible(false);
                this.frmFacileWinEN.dispose();
                this.fth.ended = false;
                this.fth.changeLang = true;
            }
            fd.dispose();
        } else if (e.getSource() == this.mntmQuit) {
            this.quitApplication();
        } else {
            this.tmr.stop();
            if (this.currPage == PagesEnum.MeasurementWnd) {
                this.readTestFromDev();
                this.tmr.start();
            }
        }
    }

    @Override
    public void executeEvent(EventsEnum ev) {
        if (ev == EventsEnum.FacileEvCfg) {
            this.setConnectionType();
        } else if (ev == EventsEnum.FacileEvOffline) {
            this.fapp.isOffline = true;
            this.setLoadTest();
        } else if (ev == EventsEnum.FacileEvUSB) {
            this.setPageConnectionMode();
        } else if (ev == EventsEnum.StartConnManually) {
            this.startConnectingToDevice();
        } else if (ev == EventsEnum.UpdateCommPorts) {
            this.updateCommPorts();
        } else if (ev == EventsEnum.FacileEvTest) {
            this.setMeasPage();
        } else if (ev == EventsEnum.FacileEvCfgDefault) {
            Params.setFactoryDefault();
            this.setSettingsCommunication();
        } else if (ev == EventsEnum.FacileEvLoadDev) {
            if (this.readCfgFromDev()) {
                this.setSettingsCommunication();
            }
        } else if (ev == EventsEnum.FacileEvSendDev) {
            if (this.sendCfgToDev()) {
                this.setMeasPage();
            }
        } else if (ev == EventsEnum.FacileEvSaveFile) {
            this.saveSettingsFile();
        } else if (ev == EventsEnum.FacileEvLoadFile) {
            this.loadSettingsFile();
        } else if (ev == EventsEnum.FacileEvGoCfgStart) {
            this.setLoadTest();
        }
    }

    protected void setFacilePage(PagesEnum p, Component c) {
        this.fapp.ultimaPagina = this.currPage;
        this.fapp.ultimaPaginaValida = true;
        this.currPage = p;
        this.pnlTab.removeAll();
        this.pnlTab.add(c);
        this.pnlTab.repaint();
        this.pnlTab.setVisible(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pnlTab.setVisible(true);
    }

    protected void setPageIntro() {
        this.setFacilePage(PagesEnum.Intro, this.pnlIntroWnd);
        this.btnHome.setEnabled(false);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(false);
        this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 0.0.");
    }

    protected void setConnectionType() {
        this.setFacilePage(PagesEnum.ConnectionTypeWnd, this.pnlConnType);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setPageConnectionMode() {
        this.setFacilePage(PagesEnum.ConnectionMode, this.pnlConnMode);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setFacileCommPortSelection() {
        this.setFacilePage(PagesEnum.ConnectionMode, this.pnlConnMode);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setMeasPage() {
        this.setFacilePage(PagesEnum.MeasurementWnd, this.pnlMeasurement);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
        this.tmr.setInitialDelay(5);
        this.tmr.setDelay(10);
        this.tmr.setRepeats(false);
        this.tmr.start();
    }

    protected void setCommPortSelection() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.pnlCommPortSelection.setSerialPorts(coms);
        this.setFacilePage(PagesEnum.CommPortSelection, this.pnlCommPortSelection);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setLoadTest() {
        this.pnlLoadTest.setOffline(this.fapp.isOffline);
        this.setFacilePage(PagesEnum.LoadTest, this.pnlLoadTest);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void setSettingsPage() {
        this.pnlSettings.initSettings();
        this.setFacilePage(PagesEnum.Settings, this.pnlSettings);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setSettingsCommunication() {
        this.pnlSettingsComm.initSettings();
        String[] coms = this.fapp.facileGetCommPorts();
        this.pnlCommPortSelection.setSerialPorts(coms);
        this.setFacilePage(PagesEnum.SettingsComm, this.pnlSettingsComm);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(true);
        this.btnIndietro.setEnabled(true);
    }

    protected void setMenuSaveSendTest() {
        this.pnlMenuSaveSend.setOffline(this.fapp.isOffline);
        this.setFacilePage(PagesEnum.MenuSaveSend, this.pnlMenuSaveSend);
        this.btnHome.setEnabled(true);
        this.btnAvanti.setEnabled(false);
        this.btnIndietro.setEnabled(true);
    }

    protected void updateCommPorts() {
        String[] coms = this.fapp.facileGetCommPorts();
        this.pnlCommPortSelection.setSerialPorts(coms);
    }

    private void startConnectingToDevice() {
        Object[] options = new Object[]{FacileParam.loadLanguage("btnContinue")};
        String com = this.pnlCommPortSelection.getSelectedComPort();
        System.out.println("Odabrani COM port:" + com);
        this.fapp.modbusAddr = 1;
        this.fapp.comBaud = 3;
        Params.mbBaud = 3;
        this.fapp.comParity = 0;
        this.fapp.qiDelay = 1;
        if (this.fapp.checkConnected(com)) {
            if (this.fapp.fw_read == -1) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxConnErrorText"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options, options[0]);
            } else if (this.fapp.fw_read >= 0 && this.fapp.fw_read <= 768) {
                this.frmFacileWinEN.setTitle(String.valueOf(FacileParam.loadLanguage("APPNAME")) + " ver. 0.0 " + Params.appFirmware + " " + FacileParam.loadLanguage("MachineIDTitle") + Params.machineID);
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxConnOK"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options, options[0]);
                this.setLoadTest();
            } else {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, String.format(FacileParam.loadLanguage("msgBoxIncompatabile"), this.fapp.fw_read / 100, this.fapp.fw_read % 100 / 10, this.fapp.fw_read % 100 % 10), FacileParam.loadLanguage("APPNAME"), 0, 2, null, options, options[0]);
            }
        } else {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxNoConn"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options, options[0]);
            this.fapp.modbus_close();
        }
    }

    private void quitApplication() {
        Object[] options = new Object[]{FacileParam.loadLanguage("msgBoxBtnYES"), FacileParam.loadLanguage("msgBoxBtnNO")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxExitAPP"), FacileParam.loadLanguage("APPNAME"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
            this.fth.changeLang = false;
        }
    }

    private void endTestTimer() {
        this.tmr.stop();
        if (this.mbOpened) {
            this.fapp.modbus_close();
            this.mbOpened = false;
        }
    }

    private boolean sendCfgToDev() {
        boolean ok = false;
        byte[] reply = null;
        if (this.fapp.modbus_open()) {
            long[] values = null;
            long[] valuesRE = null;
            values = new long[1];
            valuesRE = new long[1];
            values[0] = Params.FLedge[0] * 1 + Params.FLedge[1] * 2 + Params.FLedge[2] * 4 + Params.FLedge[3] * 8 + Params.FLedge[4] * 16 + Params.FLedge[5] * 32 + Params.FLedge[6] * 64 + Params.FLedge[7] * 128 + Params.FLedge[8] * 256 + Params.FLedge[9] * 512 + Params.FLedge[10] * 1024 + Params.FLedge[11] * 2048;
            valuesRE[0] = Params.RisingEdge[0] * 1 + Params.RisingEdge[1] * 2 + Params.RisingEdge[2] * 4 + Params.RisingEdge[3] * 8 + Params.RisingEdge[4] * 16 + Params.RisingEdge[5] * 32 + Params.RisingEdge[6] * 64 + Params.RisingEdge[7] * 128 + Params.RisingEdge[8] * 256 + Params.RisingEdge[9] * 512 + Params.RisingEdge[10] * 1024 + Params.RisingEdge[11] * 2048;
            reply = this.fapp.modbus_write_single_register(78, values[0]);
            reply = this.fapp.modbus_write_single_register(91, valuesRE[0]);
            reply = this.fapp.modbus_write_single_register(94, Params.mbBaud);
            long[] commValues = null;
            commValues = new long[]{Params.mbAddr * 256 + Params.mbParity * 1 + Params.mbStopbit * 4};
            reply = this.fapp.modbus_write_single_register(93, commValues[0]);
            if (reply != null) {
                values = new long[2];
                values = this.fapp.long_to_16bit_reg(Params.thresholdValue[0]);
                reply = this.fapp.modbus_write_multiple_register(50, values);
                if (reply != null) {
                    values = new long[2];
                    values = this.fapp.long_to_16bit_reg(Params.thresholdValue[1]);
                    reply = this.fapp.modbus_write_multiple_register(52, values);
                    if (reply != null) {
                        values = new long[2];
                        values = this.fapp.long_to_16bit_reg(Params.thresholdValue[2]);
                        reply = this.fapp.modbus_write_multiple_register(54, values);
                        if (reply != null) {
                            values = new long[2];
                            values = this.fapp.long_to_16bit_reg(Params.thresholdValue[3]);
                            reply = this.fapp.modbus_write_multiple_register(56, values);
                            if (reply != null) {
                                values = new long[2];
                                values = this.fapp.long_to_16bit_reg(Params.thresholdValue[4]);
                                reply = this.fapp.modbus_write_multiple_register(58, values);
                                if (reply != null) {
                                    values = new long[2];
                                    values = this.fapp.long_to_16bit_reg(Params.thresholdValue[5]);
                                    reply = this.fapp.modbus_write_multiple_register(60, values);
                                    if (reply != null) {
                                        values = new long[2];
                                        values = this.fapp.long_to_16bit_reg(Params.thresholdValue[6]);
                                        reply = this.fapp.modbus_write_multiple_register(62, values);
                                        if (reply != null) {
                                            values = new long[2];
                                            values = this.fapp.long_to_16bit_reg(Params.thresholdValue[7]);
                                            reply = this.fapp.modbus_write_multiple_register(64, values);
                                            if (reply != null) {
                                                values = new long[2];
                                                values = this.fapp.long_to_16bit_reg(Params.thresholdValue[8]);
                                                reply = this.fapp.modbus_write_multiple_register(66, values);
                                                if (reply != null) {
                                                    values = new long[2];
                                                    values = this.fapp.long_to_16bit_reg(Params.thresholdValue[9]);
                                                    reply = this.fapp.modbus_write_multiple_register(68, values);
                                                    if (reply != null) {
                                                        values = new long[2];
                                                        values = this.fapp.long_to_16bit_reg(Params.thresholdValue[10]);
                                                        reply = this.fapp.modbus_write_multiple_register(70, values);
                                                        if (reply != null) {
                                                            values = new long[2];
                                                            values = this.fapp.long_to_16bit_reg(Params.thresholdValue[11]);
                                                            reply = this.fapp.modbus_write_multiple_register(72, values);
                                                            if (reply != null) {
                                                                ok = true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ((reply = this.fapp.modbus_write_single_register(79, Params.filterValue[0])) != null && (reply = this.fapp.modbus_write_single_register(80, Params.filterValue[1])) != null && (reply = this.fapp.modbus_write_single_register(81, Params.filterValue[2])) != null && (reply = this.fapp.modbus_write_single_register(82, Params.filterValue[3])) != null && (reply = this.fapp.modbus_write_single_register(83, Params.filterValue[4])) != null && (reply = this.fapp.modbus_write_single_register(84, Params.filterValue[5])) != null && (reply = this.fapp.modbus_write_single_register(85, Params.filterValue[6])) != null && (reply = this.fapp.modbus_write_single_register(86, Params.filterValue[7])) != null && (reply = this.fapp.modbus_write_single_register(87, Params.filterValue[8])) != null && (reply = this.fapp.modbus_write_single_register(88, Params.filterValue[9])) != null && (reply = this.fapp.modbus_write_single_register(89, Params.filterValue[10])) != null && (reply = this.fapp.modbus_write_single_register(90, Params.filterValue[11])) != null) {
                ok = true;
            }
            long[] nonVolatile = null;
            nonVolatile = new long[]{Params.doutInitState[0] * 1 + Params.doutInitState[1] * 2 + Params.doutInitState[2] * 4 + Params.doutInitState[3] * 8 + Params.nonVolatileTot * 16384 + Params.nonVolatileDout * 32768};
            reply = this.fapp.modbus_write_single_register(92, nonVolatile[0]);
            if (reply != null) {
                ok = true;
            }
            if (ok && (reply = this.fapp.modbus_write_single_register(120, 49600L)) != null && (reply = this.fapp.modbus_write_single_register(120, 49568L)) != null) {
                ok = true;
            }
        }
        Object[] options3 = new Object[]{FacileParam.loadLanguage("btnContinue")};
        if (ok) {
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("setConf"), FacileParam.loadLanguage("APPNAME"), 0, 1, null, options3, options3[0]);
        } else {
            this.fapp.modbus_close();
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("setConfErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
        }
        return ok;
    }

    private boolean readCfgFromDev() {
        boolean ok = false;
        int[] valuesCommSet = null;
        int[] valuesComm = null;
        int[] valuesFRsetting = null;
        int[] valuesREsetting = null;
        int[] valuesTHSettings = null;
        int[] valuesFilterSettings = null;
        int[] nonVolatile = null;
        if (this.fapp.modbus_open()) {
            valuesCommSet = this.fapp.modbus_read_holding_register(93, 1);
            if (valuesCommSet != null) {
                Params.mbParity = valuesCommSet[0] & 3;
                Params.mbStopbit = (valuesCommSet[0] & 4) / 4;
                short reg = (short)valuesCommSet[0];
                int a = reg & 3;
                int b = reg >> 2 & 1;
                int c = reg >> 8;
                Params.mbAddr = (valuesCommSet[0] & 0xFF00) / 256;
            }
            if ((valuesComm = this.fapp.modbus_read_holding_register(94, 1)) != null) {
                Params.mbBaud = valuesComm[0];
            }
            if ((valuesFRsetting = this.fapp.modbus_read_holding_register(78, 1)) != null) {
                Params.FLedge[0] = (valuesFRsetting[0] & 1) / 1;
                Params.FLedge[1] = (valuesFRsetting[0] & 2) / 2;
                Params.FLedge[2] = (valuesFRsetting[0] & 4) / 4;
                Params.FLedge[3] = (valuesFRsetting[0] & 8) / 8;
                Params.FLedge[4] = (valuesFRsetting[0] & 0x10) / 16;
                Params.FLedge[5] = (valuesFRsetting[0] & 0x20) / 32;
                Params.FLedge[6] = (valuesFRsetting[0] & 0x40) / 64;
                Params.FLedge[7] = (valuesFRsetting[0] & 0x80) / 128;
                Params.FLedge[8] = (valuesFRsetting[0] & 0x100) / 256;
                Params.FLedge[9] = (valuesFRsetting[0] & 0x200) / 512;
                Params.FLedge[10] = (valuesFRsetting[0] & 0x400) / 1024;
                Params.FLedge[11] = (valuesFRsetting[0] & 0x800) / 2048;
            }
            valuesREsetting = this.fapp.modbus_read_holding_register(91, 1);
            if (valuesFRsetting != null) {
                Params.RisingEdge[0] = (valuesREsetting[0] & 1) / 1;
                Params.RisingEdge[1] = (valuesREsetting[0] & 2) / 2;
                Params.RisingEdge[2] = (valuesREsetting[0] & 4) / 4;
                Params.RisingEdge[3] = (valuesREsetting[0] & 8) / 8;
                Params.RisingEdge[4] = (valuesREsetting[0] & 0x10) / 16;
                Params.RisingEdge[5] = (valuesREsetting[0] & 0x20) / 32;
                Params.RisingEdge[6] = (valuesREsetting[0] & 0x40) / 64;
                Params.RisingEdge[7] = (valuesREsetting[0] & 0x80) / 128;
                Params.RisingEdge[8] = (valuesREsetting[0] & 0x100) / 256;
                Params.RisingEdge[9] = (valuesREsetting[0] & 0x200) / 512;
                Params.RisingEdge[10] = (valuesREsetting[0] & 0x400) / 1024;
                Params.RisingEdge[11] = (valuesREsetting[0] & 0x800) / 2048;
            }
            if ((valuesTHSettings = this.fapp.modbus_read_holding_register(50, 24)) != null) {
                Params.thresholdValue[0] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 0);
                Params.thresholdValue[1] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 2);
                Params.thresholdValue[2] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 4);
                Params.thresholdValue[3] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 6);
                Params.thresholdValue[4] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 8);
                Params.thresholdValue[5] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 10);
                Params.thresholdValue[6] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 12);
                Params.thresholdValue[7] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 14);
                Params.thresholdValue[8] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 16);
                Params.thresholdValue[9] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 18);
                Params.thresholdValue[10] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 20);
                Params.thresholdValue[11] = this.fapp.modbus_lsw_to_long(valuesTHSettings, 22);
            }
            if ((valuesFilterSettings = this.fapp.modbus_read_holding_register(79, 12)) != null) {
                Params.filterValue[0] = valuesFilterSettings[0];
                Params.filterValue[1] = valuesFilterSettings[1];
                Params.filterValue[2] = valuesFilterSettings[2];
                Params.filterValue[3] = valuesFilterSettings[3];
                Params.filterValue[4] = valuesFilterSettings[4];
                Params.filterValue[5] = valuesFilterSettings[5];
                Params.filterValue[6] = valuesFilterSettings[6];
                Params.filterValue[7] = valuesFilterSettings[7];
                Params.filterValue[8] = valuesFilterSettings[8];
                Params.filterValue[9] = valuesFilterSettings[9];
                Params.filterValue[10] = valuesFilterSettings[10];
                Params.filterValue[11] = valuesFilterSettings[11];
            }
            if ((nonVolatile = this.fapp.modbus_read_holding_register(92, 1)) != null) {
                Params.doutInitState[0] = (nonVolatile[0] & 1) / 1;
                Params.doutInitState[1] = (nonVolatile[0] & 2) / 2;
                Params.doutInitState[2] = (nonVolatile[0] & 4) / 4;
                Params.doutInitState[3] = (nonVolatile[0] & 8) / 8;
                Params.nonVolatileTot = (nonVolatile[0] & 0x4000) / 16384;
                Params.nonVolatileDout = (nonVolatile[0] & 0x8000) / 32768;
            }
            if (valuesFilterSettings != null && valuesFRsetting != null && valuesREsetting != null && valuesTHSettings != null) {
                ok = true;
            }
        }
        return ok;
    }

    private boolean readTestFromDev() {
        boolean ok = false;
        try {
            byte[] reply = null;
            Object[] options3 = new Object[]{FacileParam.loadLanguage("btnContinue")};
            ok = false;
            if (this.mbOpened) {
                ok = true;
            } else {
                this.fapp.comBaud = Params.mbBaud;
                this.fapp.comParity = Params.mbParity;
                this.fapp.comStopBits = Params.mbStopbit;
                this.fapp.modbusAddr = Params.mbAddr;
                if (this.fapp.modbus_open()) {
                    this.mbOpened = true;
                    ok = true;
                }
            }
            if (ok) {
                int[] baudRate = null;
                baudRate = this.fapp.modbus_read_holding_register(94, 1);
                int[] parity = this.fapp.modbus_read_holding_register(93, 1);
                int parityN = parity[0] & 3;
                String parityDesc = "";
                if (parityN == 0) {
                    parityDesc = "NONE";
                } else if (parityN == 1) {
                    parityDesc = "ODD";
                } else if (parityN == 2) {
                    parityDesc = "EVEN";
                }
                this.fapp.comBaud = baudRate[0];
                int[] valuesTotalizer = null;
                valuesTotalizer = this.fapp.modbus_read_holding_register(14, 24);
                int[] totalizerStatus = new int[1];
                int[] totalizerStatusArray = new int[12];
                totalizerStatus = this.fapp.modbus_read_holding_register(3, 1);
                totalizerStatusArray[0] = (totalizerStatus[0] & 1) / 1;
                totalizerStatusArray[1] = (totalizerStatus[0] & 2) / 2;
                totalizerStatusArray[2] = (totalizerStatus[0] & 4) / 4;
                totalizerStatusArray[3] = (totalizerStatus[0] & 8) / 8;
                totalizerStatusArray[4] = (totalizerStatus[0] & 0x10) / 16;
                totalizerStatusArray[5] = (totalizerStatus[0] & 0x20) / 32;
                totalizerStatusArray[6] = (totalizerStatus[0] & 0x40) / 64;
                totalizerStatusArray[7] = (totalizerStatus[0] & 0x80) / 128;
                totalizerStatusArray[8] = (totalizerStatus[0] & 0x100) / 256;
                totalizerStatusArray[9] = (totalizerStatus[0] & 0x200) / 512;
                totalizerStatusArray[10] = (totalizerStatus[0] & 0x400) / 1024;
                totalizerStatusArray[11] = (totalizerStatus[0] & 0x800) / 2048;
                int[] overunderStatus = new int[1];
                int[] overunderStatusArray = new int[12];
                overunderStatus = this.fapp.modbus_read_holding_register(11, 1);
                overunderStatusArray[0] = (overunderStatus[0] & 1) / 1;
                overunderStatusArray[1] = (overunderStatus[0] & 2) / 2;
                overunderStatusArray[2] = (overunderStatus[0] & 4) / 4;
                overunderStatusArray[3] = (overunderStatus[0] & 8) / 8;
                overunderStatusArray[4] = (overunderStatus[0] & 0x10) / 16;
                overunderStatusArray[5] = (overunderStatus[0] & 0x20) / 32;
                overunderStatusArray[6] = (overunderStatus[0] & 0x40) / 64;
                overunderStatusArray[7] = (overunderStatus[0] & 0x80) / 128;
                overunderStatusArray[8] = (overunderStatus[0] & 0x100) / 256;
                overunderStatusArray[9] = (overunderStatus[0] & 0x200) / 512;
                overunderStatusArray[10] = (overunderStatus[0] & 0x400) / 1024;
                overunderStatusArray[11] = (overunderStatus[0] & 0x800) / 2048;
                int[] onoffdigout = new int[1];
                int[] onoffdigoutArray = new int[4];
                onoffdigout = this.fapp.modbus_read_holding_register(10, 1);
                onoffdigoutArray[0] = (onoffdigout[0] & 1) / 1;
                onoffdigoutArray[1] = (onoffdigout[0] & 2) / 2;
                onoffdigoutArray[2] = (onoffdigout[0] & 4) / 4;
                onoffdigoutArray[3] = (onoffdigout[0] & 8) / 8;
                int[] alarm = new int[1];
                int[] alarmArray = new int[8];
                alarm = this.fapp.modbus_read_holding_register(2, 1);
                alarmArray[0] = (alarm[0] & 1) / 1;
                alarmArray[1] = (alarm[0] & 2) / 2;
                alarmArray[2] = (alarm[0] & 4) / 4;
                alarmArray[3] = (alarm[0] & 8) / 8;
                alarmArray[4] = (alarm[0] & 0x10) / 16;
                alarmArray[5] = (alarm[0] & 0x20) / 32;
                alarmArray[6] = (alarm[0] & 0x40) / 64;
                alarmArray[7] = (alarm[0] & 0x80) / 128;
                int[] digOutStatus = new int[1];
                int[] digOutStatusArray = new int[4];
                digOutStatus = this.fapp.modbus_read_holding_register(4, 1);
                digOutStatusArray[0] = (digOutStatus[0] & 1) / 1;
                digOutStatusArray[1] = (digOutStatus[0] & 2) / 2;
                digOutStatusArray[2] = (digOutStatus[0] & 4) / 4;
                digOutStatusArray[3] = (digOutStatus[0] & 8) / 8;
                int[] serialNumber = null;
                serialNumber = this.fapp.modbus_read_holding_register(123, 3);
                this.pnlMeasurement.setValues(valuesTotalizer, totalizerStatusArray, overunderStatusArray, onoffdigoutArray, alarmArray, digOutStatusArray);
                this.pnlMeasurement.avanzamento();
                this.pnlMeasurement.setCommString(String.valueOf(this.fapp.getBaudString()) + " Baud, Parity: " + parityDesc + ", " + this.fapp.getStopBitsString() + " Stopbit " + "- File TAR:" + serialNumber[2] + serialNumber[1] + serialNumber[0] + " - FW = " + Params.appFirmware);
                long[] writeValue = null;
                int[] overunderStatusArraySelected = null;
                int[] onoffdigStatusArraySelected = null;
                if (this.pnlMeasurement.getWritePending() == 1) {
                    this.pnlMeasurement.resetWritePending();
                    writeValue = new long[1];
                    overunderStatusArraySelected = this.pnlMeasurement.getArrayOverUnderStatus();
                    writeValue[0] = overunderStatusArraySelected[0] * 1 + overunderStatusArraySelected[1] * 2 + overunderStatusArraySelected[2] * 4 + overunderStatusArraySelected[3] * 8 + (overunderStatusArraySelected[4] * 16 + overunderStatusArraySelected[5] * 32 + overunderStatusArraySelected[6] * 64 + overunderStatusArraySelected[7] * 128 + overunderStatusArraySelected[8] * 256 + overunderStatusArraySelected[9] * 512 + overunderStatusArraySelected[10] * 1024 + overunderStatusArraySelected[11] * 2048);
                    reply = this.fapp.modbus_write_single_register(11, writeValue[0]);
                    if (reply != null) {
                        ok = true;
                    }
                } else if (this.pnlMeasurement.getWritePending() == 2) {
                    this.pnlMeasurement.resetWritePending();
                    writeValue = new long[1];
                    onoffdigStatusArraySelected = this.pnlMeasurement.getArrayDigOutStatus();
                    writeValue[0] = onoffdigStatusArraySelected[0] * 1 + onoffdigStatusArraySelected[1] * 2 + onoffdigStatusArraySelected[2] * 4 + onoffdigStatusArraySelected[3] * 8;
                    reply = this.fapp.modbus_write_single_register(10, writeValue[0]);
                    if (reply != null) {
                        ok = true;
                    }
                } else if (this.pnlMeasurement.getWritePending() == 3) {
                    long[] values = null;
                    int m = this.pnlMeasurement.getWriteSource();
                    long v = this.pnlMeasurement.getWriteValue();
                    this.pnlMeasurement.resetWritePending();
                    values = new long[1];
                    values = new long[2];
                    values = this.fapp.long_to_16bit_reg(v);
                    reply = this.fapp.modbus_write_multiple_register(14 + m, values);
                    if (reply != null) {
                        ok = true;
                    }
                }
            }
        }
        catch (NullPointerException ex) {
            ok = false;
        }
        return ok;
    }

    private void saveSettingsFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showSaveDialog(this.frmFacileWinEN) == 0) {
            String extension;
            File fn = f.getSelectedFile();
            String path = fn.getAbsolutePath();
            if (!path.endsWith(extension = ".TXT")) {
                fn = new File(String.valueOf(path) + extension);
            }
            Object[] options3 = new Object[]{"CONTINUE"};
            boolean toSave = false;
            if (fn.exists()) {
                Object[] options2 = new Object[]{FacileParam.loadLanguage("msgBoxBtnOK"), FacileParam.loadLanguage("msgBoxBtnCancel")};
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxSaveSettings"), FacileParam.loadLanguage("APPNAME"), 0, 2, null, options2, options2[1]);
                if (n == 0) {
                    toSave = true;
                }
            } else {
                toSave = true;
            }
            if (toSave && !this.fapp.saveCfg(fn.getAbsolutePath())) {
                int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxSaveSettingErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
            }
        }
    }

    private void loadSettingsFile() {
        JFileChooser f = new JFileChooser();
        f.setFileSelectionMode(0);
        f.setFileFilter(new FileNameExtensionFilter("CONFIGURATION FILE", "TXT"));
        f.setMultiSelectionEnabled(false);
        if (f.showOpenDialog(this.frmFacileWinEN) == 0) {
            File fn = f.getSelectedFile();
            Object[] options3 = new Object[]{"Load file"};
            if (fn.isFile() && fn.exists()) {
                if (this.fapp.loadCfg(fn.getAbsolutePath())) {
                    this.setSettingsPage();
                } else {
                    int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxLoadSettingErr"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
                }
                return;
            }
            int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxLoadSettingNotExist"), FacileParam.loadLanguage("APPNAME"), 0, 0, null, options3, options3[0]);
        }
    }

    private void exitFromApp() {
        Object[] options = new Object[]{FacileParam.loadLanguage("msgBoxBtnYES"), FacileParam.loadLanguage("msgBoxBtnNO")};
        int n = JOptionPane.showOptionDialog(this.frmFacileWinEN, FacileParam.loadLanguage("msgBoxExitAPP"), FacileParam.loadLanguage("APPNAME"), 0, 3, null, options, options[0]);
        if (n == 0) {
            this.endTestTimer();
            this.frmFacileWinEN.setVisible(false);
            this.frmFacileWinEN.dispose();
            this.fth.ended = true;
        } else if (n == 1) {
            this.frmFacileWinEN.setDefaultCloseOperation(0);
        }
    }
}

