/*
 * Decompiled with CFR 0.152.
 */
package QA12DI4DO;

import QA12DI4DO.FacileLangEnum;
import QA12DI4DO.FacileParam;
import QA12DI4DO.PagesEnum;
import QA12DI4DO.Params;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import java.util.prefs.Preferences;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class FacileApp {
    private String appName = "FACILE-APP-";
    private String iniKeyLang = "LANG";
    private String iniKeymbBaud = "MBBaudrate";
    private String iniKeyF00 = "F00";
    private String iniKeyF01 = "F01";
    private String iniKeyF02 = "F02";
    private String iniKeyF03 = "F03";
    private String iniKeyF04 = "F04";
    private String iniKeyF05 = "F05";
    private String iniKeyF06 = "F06";
    private String iniKeyF07 = "F07";
    private String iniKeyF08 = "F08";
    private String iniKeyF09 = "F09";
    private String iniKeyF10 = "F10";
    private String iniKeyF11 = "F11";
    private String iniKeyR00 = "R00";
    private String iniKeyR01 = "R01";
    private String iniKeyR02 = "R02";
    private String iniKeyR03 = "R03";
    private String iniKeyR04 = "R04";
    private String iniKeyR05 = "R05";
    private String iniKeyR06 = "R06";
    private String iniKeyR07 = "R07";
    private String iniKeyR08 = "R08";
    private String iniKeyR09 = "R09";
    private String iniKeyR10 = "R10";
    private String iniKeyR11 = "R11";
    private String iniKeyTh00 = "Tot00";
    private String iniKeyTh01 = "Tot01";
    private String iniKeyTh02 = "Tot02";
    private String iniKeyTh03 = "Tot03";
    private String iniKeyTh04 = "Tot04";
    private String iniKeyTh05 = "Tot05";
    private String iniKeyTh06 = "Tot06";
    private String iniKeyTh07 = "Tot07";
    private String iniKeyTh08 = "Tot08";
    private String iniKeyTh09 = "Tot09";
    private String iniKeyTh10 = "Tot10";
    private String iniKeyTh11 = "Tot11";
    private String iniKeyFreq00 = "Freq00";
    private String iniKeyFreq01 = "Freq01";
    private String iniKeyFreq02 = "Freq02";
    private String iniKeyFreq03 = "Freq03";
    private String iniKeyFreq04 = "Freq04";
    private String iniKeyFreq05 = "Freq05";
    private String iniKeyFreq06 = "Freq06";
    private String iniKeyFreq07 = "Freq07";
    private String iniKeyFreq08 = "Freq08";
    private String iniKeyFreq09 = "Freq09";
    private String iniKeyFreq10 = "Freq10";
    private String iniKeyFreq11 = "Freq11";
    private String iniKeyNonVolatileTot = "ENABLE-NON-VOLATILE-TOT";
    private String iniKeyNonVolatileDOUT = "ENABLE-NON-VOLATILE-DOUT";
    private String iniKeyDout1InitStateClosed = "DOUT1INISTATECLOSED";
    private String iniKeyDout2InitStateClosed = "DOUT2INISTATECLOSED";
    private String iniKeyDout3InitStateClosed = "DOUT3INISTATECLOSED";
    private String iniKeyDout4InitStateClosed = "DOUT4INISTATECLOSED";
    public FacileLangEnum lang;
    public FacileParam param = new FacileParam();
    public PagesEnum ultimaPagina;
    public boolean ultimaPaginaValida;
    public boolean isOffline;
    public String comName;
    public SerialPort coms;
    public int comBaud;
    public int comParity;
    public int comStopBits;
    public int modbusAddr;
    public int modbusTmo;
    public int qiDelay;
    public int fw_read = -1;
    public int[] bauds = new int[]{1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private int[] paritys;
    private int[] stopbits;

    public FacileApp() {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.paritys = nArray;
        this.stopbits = new int[]{1, 2};
    }

    public boolean saveCfg(String filename) {
        try {
            Properties p = new Properties();
            p.setProperty(this.iniKeymbBaud, String.valueOf(Params.mbBaud));
            p.setProperty(this.iniKeyF00, String.valueOf(Params.FLedge[0]));
            p.setProperty(this.iniKeyF01, String.valueOf(Params.FLedge[1]));
            p.setProperty(this.iniKeyF02, String.valueOf(Params.FLedge[2]));
            p.setProperty(this.iniKeyF03, String.valueOf(Params.FLedge[3]));
            p.setProperty(this.iniKeyF04, String.valueOf(Params.FLedge[4]));
            p.setProperty(this.iniKeyF05, String.valueOf(Params.FLedge[5]));
            p.setProperty(this.iniKeyF06, String.valueOf(Params.FLedge[6]));
            p.setProperty(this.iniKeyF07, String.valueOf(Params.FLedge[7]));
            p.setProperty(this.iniKeyF08, String.valueOf(Params.FLedge[8]));
            p.setProperty(this.iniKeyF09, String.valueOf(Params.FLedge[9]));
            p.setProperty(this.iniKeyF10, String.valueOf(Params.FLedge[10]));
            p.setProperty(this.iniKeyF11, String.valueOf(Params.FLedge[11]));
            p.setProperty(this.iniKeyR00, String.valueOf(Params.RisingEdge[0]));
            p.setProperty(this.iniKeyR01, String.valueOf(Params.RisingEdge[1]));
            p.setProperty(this.iniKeyR02, String.valueOf(Params.RisingEdge[2]));
            p.setProperty(this.iniKeyR03, String.valueOf(Params.RisingEdge[3]));
            p.setProperty(this.iniKeyR04, String.valueOf(Params.RisingEdge[4]));
            p.setProperty(this.iniKeyR05, String.valueOf(Params.RisingEdge[5]));
            p.setProperty(this.iniKeyR06, String.valueOf(Params.RisingEdge[6]));
            p.setProperty(this.iniKeyR07, String.valueOf(Params.RisingEdge[7]));
            p.setProperty(this.iniKeyR08, String.valueOf(Params.RisingEdge[8]));
            p.setProperty(this.iniKeyR09, String.valueOf(Params.RisingEdge[9]));
            p.setProperty(this.iniKeyR10, String.valueOf(Params.RisingEdge[10]));
            p.setProperty(this.iniKeyR11, String.valueOf(Params.RisingEdge[11]));
            p.setProperty(this.iniKeyTh00, String.valueOf(Params.thresholdValue[0]));
            p.setProperty(this.iniKeyTh01, String.valueOf(Params.thresholdValue[1]));
            p.setProperty(this.iniKeyTh02, String.valueOf(Params.thresholdValue[2]));
            p.setProperty(this.iniKeyTh03, String.valueOf(Params.thresholdValue[3]));
            p.setProperty(this.iniKeyTh04, String.valueOf(Params.thresholdValue[4]));
            p.setProperty(this.iniKeyTh05, String.valueOf(Params.thresholdValue[5]));
            p.setProperty(this.iniKeyTh06, String.valueOf(Params.thresholdValue[6]));
            p.setProperty(this.iniKeyTh07, String.valueOf(Params.thresholdValue[7]));
            p.setProperty(this.iniKeyTh08, String.valueOf(Params.thresholdValue[8]));
            p.setProperty(this.iniKeyTh09, String.valueOf(Params.thresholdValue[9]));
            p.setProperty(this.iniKeyTh10, String.valueOf(Params.thresholdValue[10]));
            p.setProperty(this.iniKeyTh11, String.valueOf(Params.thresholdValue[11]));
            p.setProperty(this.iniKeyFreq00, String.valueOf(Params.filterValue[0]));
            p.setProperty(this.iniKeyFreq01, String.valueOf(Params.filterValue[1]));
            p.setProperty(this.iniKeyFreq02, String.valueOf(Params.filterValue[2]));
            p.setProperty(this.iniKeyFreq03, String.valueOf(Params.filterValue[3]));
            p.setProperty(this.iniKeyFreq04, String.valueOf(Params.filterValue[4]));
            p.setProperty(this.iniKeyFreq05, String.valueOf(Params.filterValue[5]));
            p.setProperty(this.iniKeyFreq06, String.valueOf(Params.filterValue[6]));
            p.setProperty(this.iniKeyFreq07, String.valueOf(Params.filterValue[7]));
            p.setProperty(this.iniKeyFreq08, String.valueOf(Params.filterValue[8]));
            p.setProperty(this.iniKeyFreq09, String.valueOf(Params.filterValue[9]));
            p.setProperty(this.iniKeyFreq10, String.valueOf(Params.filterValue[10]));
            p.setProperty(this.iniKeyFreq11, String.valueOf(Params.filterValue[11]));
            p.setProperty(this.iniKeyNonVolatileTot, String.valueOf(Params.nonVolatileTot));
            p.setProperty(this.iniKeyNonVolatileDOUT, String.valueOf(Params.nonVolatileDout));
            p.setProperty(this.iniKeyDout1InitStateClosed, String.valueOf(Params.doutInitState[0]));
            p.setProperty(this.iniKeyDout2InitStateClosed, String.valueOf(Params.doutInitState[1]));
            p.setProperty(this.iniKeyDout3InitStateClosed, String.valueOf(Params.doutInitState[2]));
            p.setProperty(this.iniKeyDout4InitStateClosed, String.valueOf(Params.doutInitState[3]));
            p.store(new FileOutputStream(filename), "");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage().toString());
            return false;
        }
        return true;
    }

    public boolean loadCfg(String filename) {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(filename));
            Params.mbBaud = Integer.valueOf(p.getProperty(this.iniKeymbBaud));
            Params.FLedge[0] = Integer.valueOf(p.getProperty(this.iniKeyF00));
            Params.FLedge[1] = Integer.valueOf(p.getProperty(this.iniKeyF01));
            Params.FLedge[2] = Integer.valueOf(p.getProperty(this.iniKeyF02));
            Params.FLedge[3] = Integer.valueOf(p.getProperty(this.iniKeyF03));
            Params.FLedge[4] = Integer.valueOf(p.getProperty(this.iniKeyF04));
            Params.FLedge[5] = Integer.valueOf(p.getProperty(this.iniKeyF05));
            Params.FLedge[6] = Integer.valueOf(p.getProperty(this.iniKeyF06));
            Params.FLedge[7] = Integer.valueOf(p.getProperty(this.iniKeyF07));
            Params.FLedge[8] = Integer.valueOf(p.getProperty(this.iniKeyF08));
            Params.FLedge[9] = Integer.valueOf(p.getProperty(this.iniKeyF09));
            Params.FLedge[10] = Integer.valueOf(p.getProperty(this.iniKeyF10));
            Params.FLedge[11] = Integer.valueOf(p.getProperty(this.iniKeyF11));
            Params.RisingEdge[0] = Integer.valueOf(p.getProperty(this.iniKeyR00));
            Params.RisingEdge[1] = Integer.valueOf(p.getProperty(this.iniKeyR01));
            Params.RisingEdge[2] = Integer.valueOf(p.getProperty(this.iniKeyR02));
            Params.RisingEdge[3] = Integer.valueOf(p.getProperty(this.iniKeyR03));
            Params.RisingEdge[4] = Integer.valueOf(p.getProperty(this.iniKeyR04));
            Params.RisingEdge[5] = Integer.valueOf(p.getProperty(this.iniKeyR05));
            Params.RisingEdge[6] = Integer.valueOf(p.getProperty(this.iniKeyR06));
            Params.RisingEdge[7] = Integer.valueOf(p.getProperty(this.iniKeyR07));
            Params.RisingEdge[8] = Integer.valueOf(p.getProperty(this.iniKeyR08));
            Params.RisingEdge[9] = Integer.valueOf(p.getProperty(this.iniKeyR09));
            Params.RisingEdge[10] = Integer.valueOf(p.getProperty(this.iniKeyR10));
            Params.RisingEdge[11] = Integer.valueOf(p.getProperty(this.iniKeyR11));
            Params.thresholdValue[0] = Long.valueOf(p.getProperty(this.iniKeyTh00));
            Params.thresholdValue[1] = Long.valueOf(p.getProperty(this.iniKeyTh01));
            Params.thresholdValue[2] = Long.valueOf(p.getProperty(this.iniKeyTh02));
            Params.thresholdValue[3] = Long.valueOf(p.getProperty(this.iniKeyTh03));
            Params.thresholdValue[4] = Long.valueOf(p.getProperty(this.iniKeyTh04));
            Params.thresholdValue[5] = Long.valueOf(p.getProperty(this.iniKeyTh05));
            Params.thresholdValue[6] = Long.valueOf(p.getProperty(this.iniKeyTh06));
            Params.thresholdValue[7] = Long.valueOf(p.getProperty(this.iniKeyTh07));
            Params.thresholdValue[8] = Long.valueOf(p.getProperty(this.iniKeyTh08));
            Params.thresholdValue[9] = Long.valueOf(p.getProperty(this.iniKeyTh09));
            Params.thresholdValue[10] = Long.valueOf(p.getProperty(this.iniKeyTh10));
            Params.thresholdValue[11] = Long.valueOf(p.getProperty(this.iniKeyTh11));
            Params.filterValue[0] = Integer.valueOf(p.getProperty(this.iniKeyFreq00));
            Params.filterValue[1] = Integer.valueOf(p.getProperty(this.iniKeyFreq01));
            Params.filterValue[2] = Integer.valueOf(p.getProperty(this.iniKeyFreq02));
            Params.filterValue[3] = Integer.valueOf(p.getProperty(this.iniKeyFreq03));
            Params.filterValue[4] = Integer.valueOf(p.getProperty(this.iniKeyFreq04));
            Params.filterValue[5] = Integer.valueOf(p.getProperty(this.iniKeyFreq05));
            Params.filterValue[6] = Integer.valueOf(p.getProperty(this.iniKeyFreq06));
            Params.filterValue[7] = Integer.valueOf(p.getProperty(this.iniKeyFreq07));
            Params.filterValue[8] = Integer.valueOf(p.getProperty(this.iniKeyFreq08));
            Params.filterValue[9] = Integer.valueOf(p.getProperty(this.iniKeyFreq09));
            Params.filterValue[10] = Integer.valueOf(p.getProperty(this.iniKeyFreq00));
            Params.filterValue[11] = Integer.valueOf(p.getProperty(this.iniKeyFreq11));
            Params.nonVolatileTot = Integer.valueOf(p.getProperty(this.iniKeyNonVolatileTot));
            Params.nonVolatileDout = Integer.valueOf(p.getProperty(this.iniKeyNonVolatileDOUT));
            Params.doutInitState[0] = Integer.valueOf(p.getProperty(this.iniKeyDout1InitStateClosed));
            Params.doutInitState[1] = Integer.valueOf(p.getProperty(this.iniKeyDout2InitStateClosed));
            Params.doutInitState[2] = Integer.valueOf(p.getProperty(this.iniKeyDout3InitStateClosed));
            Params.doutInitState[3] = Integer.valueOf(p.getProperty(this.iniKeyDout4InitStateClosed));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void loadAppIni() {
        Preferences root = Preferences.userRoot();
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "009.ini");
        String content = "";
        this.lang = FacileLangEnum.FacileLangEN;
        try {
            FileReader reader = new FileReader(f2);
            char[] chars = new char[(int)f2.length()];
            reader.read(chars);
            content = new String(chars);
            reader.close();
            FacileParam.setLanguage(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveAppIni();
    }

    public void saveAppIni() {
        String p = FacileParam.getApplicationStartUpPath();
        File f2 = new File(p, "009.ini");
        try {
            FileWriter writer = new FileWriter(f2);
            if (FacileParam.selectedLang == null) {
                FacileParam.selectedLang = "EN";
            }
            writer.write(FacileParam.selectedLang.toString());
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String[] facileGetCommPorts() {
        return SerialPortList.getPortNames();
    }

    public boolean checkConnected(String com) {
        this.comName = com;
        this.isOffline = false;
        if (this.modbus_open()) {
            int[] rsp = this.modbus_read_holding_register(0, 2);
            if (rsp != null) {
                this.modbus_close();
                if (rsp[0] == 9) {
                    int _hw = rsp[1] / 256;
                    int _fw = rsp[1] % 256;
                    System.out.println("HW ver.:" + _hw);
                    System.out.println("FW ver.:" + _fw);
                    int _firmwareVer1 = _fw / 100;
                    int _firmwareVer2 = _fw % 100 / 10;
                    int _firmwareVer3 = _fw % 100 % 10;
                    Params.machineID = rsp[0];
                    Params.appFirmware = String.format("FW: %d.%d.%d", _firmwareVer1, _firmwareVer2, _firmwareVer3);
                    this.fw_read = _fw;
                } else {
                    this.fw_read = -1;
                }
                return true;
            }
            this.modbus_close();
            return false;
        }
        this.modbus_close();
        return false;
    }

    public String getStopBitsString() {
        if (this.comStopBits == 0) {
            return "1";
        }
        return "2";
    }

    private byte[] CRC_16(byte[] pbytModbus) {
        byte[] crc = new byte[2];
        int intLength = pbytModbus.length - 2;
        int lngCRC = 65535;
        int lngGenerator = 40961;
        int intI = 0;
        while (intI < intLength) {
            byte temp = pbytModbus[intI];
            lngCRC ^= temp & 0xFF;
            int intJ = 0;
            while (intJ < 8) {
                boolean blnBit = (lngCRC & 1) != 0;
                lngCRC >>>= 1;
                if (blnBit) {
                    lngCRC ^= 0xA001;
                }
                ++intJ;
            }
            ++intI;
        }
        crc[0] = (byte)(lngCRC & 0xFF);
        crc[1] = (byte)(lngCRC >> 8);
        return crc;
    }

    private void add_CRC_16(byte[] pbytModbus) {
        int intLength = pbytModbus.length - 2;
        byte[] crc = this.CRC_16(pbytModbus);
        pbytModbus[intLength++] = crc[0];
        pbytModbus[intLength] = crc[1];
    }

    private boolean Check_CRC(byte[] pbytModbus) {
        byte[] crc = this.CRC_16(pbytModbus);
        return crc[0] == pbytModbus[pbytModbus.length - 2] && crc[1] == pbytModbus[pbytModbus.length - 1];
    }

    private byte intToByte(int v) {
        byte b;
        if (v > 127) {
            b = (byte)v;
            b = (byte)(b + 256);
        } else {
            b = (byte)v;
        }
        return b;
    }

    private byte[] Read_Holding_Registers(int addr, int startRegister, int nRegister) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 3;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = 0;
        bytMessaggio[5] = (byte)nRegister;
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Single_Register(int addr, int Register, long Value) {
        byte[] bytMessaggio = new byte[8];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 6;
        bytMessaggio[2] = (byte)(Register >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(Register & 0xFF);
        bytMessaggio[4] = (byte)(Value >> 8 & 0xFFL);
        bytMessaggio[5] = (byte)(Value & 0xFFL);
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    private byte[] Write_Multiple_Register(int addr, int startRegister, long[] values) {
        byte[] bytMessaggio = new byte[9 + values.length * 2];
        bytMessaggio[0] = (byte)(addr & 0xFF);
        bytMessaggio[1] = 16;
        bytMessaggio[2] = (byte)(startRegister >> 8 & 0xFF);
        bytMessaggio[3] = (byte)(startRegister & 0xFF);
        bytMessaggio[4] = (byte)(values.length >> 8 & 0xFF);
        bytMessaggio[5] = (byte)(values.length & 0xFF);
        bytMessaggio[6] = (byte)(values.length * 2);
        int i = 0;
        while (i < values.length) {
            bytMessaggio[7 + i * 2] = (byte)(values[i] >> 8 & 0xFFL);
            bytMessaggio[8 + i * 2] = (byte)(values[i] & 0xFFL);
            ++i;
        }
        this.add_CRC_16(bytMessaggio);
        return bytMessaggio;
    }

    public boolean modbus_open() {
        try {
            if (this.coms != null && this.coms.isOpened()) {
                this.coms.purgePort(1);
                this.coms.purgePort(2);
                this.coms.closePort();
            }
            this.coms = new SerialPort(this.comName);
            this.coms.openPort();
            this.coms.setParams(this.bauds[this.comBaud], 8, this.stopbits[this.comStopBits], this.paritys[this.comParity]);
            this.coms.setFlowControlMode(0);
            this.modbus_setTimeout();
        }
        catch (Exception e) {
            System.out.println("MODBUS-PORT error: " + e.getMessage());
            this.modbus_close();
            try {
                this.coms.closePort();
            }
            catch (SerialPortException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void modbus_close() {
        try {
            this.coms.purgePort(1);
            this.coms.purgePort(2);
            this.coms.closePort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] modbus_send_request(byte[] req, int tmo) {
        byte[] rsp = new byte[1024];
        byte[] rsp2 = new byte[1024];
        try {
            int i;
            this.coms.writeBytes(req);
            boolean nonarrivato = true;
            int tmocnt = 0;
            int len = 0;
            while (nonarrivato) {
                Thread.sleep(50L);
                rsp2 = this.coms.readBytes();
                int len2 = rsp2 != null ? rsp2.length : 0;
                if (len2 > 0) {
                    tmocnt = 0;
                    i = 0;
                    int j = len;
                    while (i < len2) {
                        if (j < 1024) {
                            rsp[j] = rsp2[i];
                        }
                        ++i;
                        ++j;
                    }
                    len = j;
                    continue;
                }
                if (len > 0) {
                    nonarrivato = false;
                    continue;
                }
                if ((tmocnt += 50) < tmo) continue;
                nonarrivato = false;
            }
            byte[] rspf = null;
            if (len > 0) {
                rspf = new byte[len];
                i = 0;
                while (i < len) {
                    rspf[i] = rsp[i];
                    ++i;
                }
            }
            return rspf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean modbus_check_valid_rsp(byte[] rsp, int addr) {
        int len = rsp.length;
        return len > 4 && rsp[0] == (byte)addr && this.Check_CRC(rsp);
    }

    public int[] modbus_read_holding_register(int startReg, int nRegs) {
        byte[] rsp = null;
        int[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new int[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public int modbus_read_holding_register_single_value(int startReg, int nRegs) {
        int i = 1;
        byte[] rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            int rhr_rsp = (rsp[3 + 2 * i] & 0xFF) * 256 + (rsp[4 + 2 * i] & 0xFF);
            return rhr_rsp;
        }
        return -1;
    }

    public long[] modbus_read_holding_register_with_harmonics(int startReg, int nRegs) {
        byte[] rsp = null;
        long[] rhr_rsp = null;
        byte[] req = this.Read_Holding_Registers(this.modbusAddr, startReg, nRegs);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            rhr_rsp = new long[nRegs];
            int i = 0;
            while (i < nRegs) {
                rhr_rsp[i] = ((long)rsp[3 + 2 * i] & 0xFFL) * 256L + ((long)rsp[4 + 2 * i] & 0xFFL);
                ++i;
            }
            return rhr_rsp;
        }
        return null;
    }

    public byte[] modbus_write_single_register(int startReg, long value) {
        byte[] rsp = null;
        byte[] req = this.Write_Single_Register(this.modbusAddr, startReg, value);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public byte[] modbus_write_multiple_register(int startReg, long[] values) {
        byte[] rsp = null;
        byte[] req = this.Write_Multiple_Register(this.modbusAddr, startReg, values);
        rsp = this.modbus_send_request(req, this.modbusTmo);
        if (rsp != null && this.modbus_check_valid_rsp(rsp, this.modbusAddr)) {
            return rsp;
        }
        return null;
    }

    public void float_to_modbus_msw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos] = (bits & 0xFFFF0000) >>> 16;
        buf[pos + 1] = bits & 0xFFFF;
    }

    public void float_to_modbus_lsw(int[] buf, int pos, float f) {
        int bits = Float.floatToIntBits(f);
        buf[pos + 1] = (bits & 0xFFFF0000) >>> 16;
        buf[pos] = bits & 0xFFFF;
    }

    public float modbus_msw_to_float(int[] buf, int pos) {
        int bits = buf[pos] << 16;
        return Float.intBitsToFloat(bits += buf[pos + 1]);
    }

    public float modbus_lsw_to_float(int[] buf, int pos) {
        int bits = buf[pos + 1] << 16;
        return Float.intBitsToFloat(bits += buf[pos]);
    }

    public int uint16_to_sint16(int u) {
        int s = u > Short.MAX_VALUE ? u - 65536 : u;
        return s;
    }

    public int sint16_to_uint16(int s) {
        int u = s < 0 ? s + 65536 : s;
        return u;
    }

    public int float_to_int(float f) {
        int n = Math.round(f);
        return n;
    }

    public long[] long_to_16bit_reg(long v) {
        long[] values = null;
        values = new long[]{v & 0xFFFFL, v >> 16};
        return values;
    }

    public long[] long_to_unsignedlong(long v) {
        long[] values = null;
        values = new long[]{v & 0xFFFFFFFFL, v & 0xFFFFFFFFL};
        return values;
    }

    public long modbus_lsw_to_long(int[] buf, int pos) {
        int bits = buf[pos + 1] << 16;
        bits += buf[pos];
        long retVal = (long)(buf[pos] | buf[pos + 1] << 16) & 0xFFFFFFFFL;
        return retVal;
    }

    private void modbus_setTimeout() {
        this.modbusTmo = 1000;
    }

    public String getBaudString() {
        String s = String.format("%d", this.bauds[this.comBaud]);
        return s;
    }

    public String getParityString() {
        if (this.comParity == 0) {
            return "NO PARITY";
        }
        if (this.comParity == 1) {
            return "ODD PARITY";
        }
        return "EVEN PARITY";
    }

    public String getDelayString() {
        String s = String.format("%d", this.qiDelay);
        return s;
    }

    static class SerialPortReader
    implements SerialPortEventListener {
        SerialPortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR()) {
                System.out.println(String.format("%d", event.getEventValue()));
            } else if (event.isCTS()) {
                if (event.getEventValue() == 1) {
                    System.out.println("CTS - ON");
                } else {
                    System.out.println("CTS - OFF");
                }
            } else if (event.isDSR()) {
                if (event.getEventValue() == 1) {
                    System.out.println("DSR - ON");
                } else {
                    System.out.println("DSR - OFF");
                }
            }
        }
    }
}

